/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * result.h
 */

#ifndef RESULT_H
#define RESULT_H

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct Result_tag {
    double energy;
    double ke;
    double pe;
    double bond;
    double angle;
    double dihed;
    double impr;
    double elec;
    double vdw;
    double bound;
    double temp;
    double vol;
    double press;
    double virial[9];
    MD_Dvec linmo;
    MD_Dvec angmo;
    MD_Dvec fcorr;      /* force correction */
    MD_Dvec wcomd;      /* weighted displacement of center of mass */
    double shadow[6];
    double nhexten;     /* Nose-Hoover extended energy */
    double nhfric;      /* Nose-Hoover thermodynamic friction coefficient */
    double nhlogs;      /* Nose-Hoover log s */
    double druexten;    /* thermalized Drude extended energy */
    double drucome;     /* thermalized Drude COM energy */
    double drubonde;    /* thermalized Drude bond energy */
    double drucomt;     /* Drude COM temperature */
    double drubondt;    /* Drude bond temperature */
  } Result;

#ifdef __cplusplus
}
#endif

#endif /* RESULT_H */
