/*
 * Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
 *
 * demo_array.c - Demonstrate use of Array ADT
 */

#include <stdio.h>
#include <stdlib.h>
#include "adt/array.h"

int main(void)
{
#define LEN1 10
#define LEN2 20
#define LEN3  5
  adt_Array *a;
  int j, k, len;

  /* create initial array */
  if ((a = adt_createArray(sizeof(int), LEN1, NULL)) == NULL) {
    fprintf(stderr, "adt_createArray() failed\n");
    exit(1);
  }
  /* set array elements */
  len = adt_getLengthArray(a);
  for (k = 0;  k < len;  k++) {
    j = k + 1;
    adt_updateArray(a, k, &j);
  }
  /* print array elements */
  printf("original array:\n");
  for (k = 0;  k < len;  k++) {
    printf("%d ", *((int *) adt_indexArray(a, k)));
  }
  printf("\n");
  /* resize array larger */
  if (adt_resizeArray(a, LEN2)) {
    fprintf(stderr, "adt_resizeArray() failed\n");
    exit(1);
  }
  /* set new array elements */
  for (k = len;  k < adt_getLengthArray(a);  k++) {
    j = k + 1;
    adt_updateArray(a, k, &j);
  }
  /* print array elements */
  printf("extended array:\n");
  for (k = 0;  k < adt_getLengthArray(a);  k++) {
    printf("%d ", *((int *) adt_indexArray(a, k)));
  }
  printf("\n");
  /* resize array smaller */
  if (adt_resizeArray(a, LEN3)) {
    fprintf(stderr, "adt_resizeArray() failed\n");
    exit(1);
  }
  /* print array elements */
  printf("truncated array:\n");
  for (k = 0;  k < adt_getLengthArray(a);  k++) {
    printf("%d ", *((int *) adt_indexArray(a, k)));
  }
  printf("\n");
  adt_destroyArray(a);
  return 0;
}
