#
# Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
#
# doc.mk
# build MDX documentation

ifeq (,$(strip $(TYPE)))
TYPE := pdf ps
endif

.PHONY : $(DOC) $(TYPE)

ifndef latex_cmd
define latex_cmd
latex $(basename $<)
-bibtex $(basename $<)
latex $(basename $<)
latex $(basename $<)
endef
endif

ifndef pdflatex_cmd
define pdflatex_cmd
pdflatex $(basename $<)
-bibtex $(basename $<)
pdflatex $(basename $<)
pdflatex $(basename $<)
mv $(notdir $@) ..
endef
endif

dvips_opts ?= -t letter
ifndef dvips_cmd
define dvips_cmd
dvips $(dvips_opts) -o $@ $<
mv $(notdir $@) ..
endef
endif

$(DOC) : $(TYPE)

pdf : ../$(NAME).pdf

ps : ../$(NAME).ps

../$(NAME).pdf : $(NAME).tex $(DEPS)
	$(pdflatex_cmd)

../%.ps : %.dvi
	$(dvips_cmd)

$(NAME).dvi : $(NAME).tex $(DEPS)
	$(latex_cmd)
