#
# Copyright (C) 2003-2006 by David J. Hardy.  All rights reserved.
#
# build for current release Darwin Mac OS X v10.4 (Tiger)
# using generic optimization for either Intel or PPC
#
# note: system library names specified in dlib_*liblist definitions below 
# have changed from Panther
 
# used in gnu make implicit rules
LIBTOOL := libtool 
CC := cc
CXX := c++
CPPFLAGS := -DMDX_DARWIN -D_GNU_SOURCE -iquote $(srcdir) -Wall -pedantic
CFLAGS := -O -std=c99
CXXFLAGS := -O -std=c++98
TARGET_ARCH :=
LDFLAGS :=
LOADLIBES :=
LDLIBS :=

# flags for computing dependencies
DEPFLAGS := -MM 

# definitions for linking static libraries
slib_name := lib$(NAME).a
slib_linkflags := -static -L$(libdir)

# definitions for linking dynamic libraries
dlib_name := lib$(NAME).dylib
dlib_flags := -fPIC -dynamic
dlib_linkflags := -dynamic -L$(libdir)
dlib_linkflags += -install_name $(INSTALL_LIB)/$(dlib_name)
dlib_cliblist := -lc -lgcc_s.1
dlib_cxxliblist := -lstdc++.6 -lc -lgcc_s.1

# definitions for linking plugins (dynamically loadable modules)
plug_name := $(NAME).bundle
plug_flags := -fPIC -shared -dynamic
plug_linkflags := -bundle

# definitions for linking binary executables
bin_name := $(NAME)
bin_linkflags := -L$(libdir)

# extra link options needed for optional libraries
ifneq (,$(strip $(filter-out $(libdir),$(optlib_dirlist))))
dlib_linkflags += $(addprefix -L,$(optlib_dirlist))
#plug_linkflags += $(addprefix -L,$(optlib_dirlist))
bin_linkflags += $(addprefix -L,$(optlib_dirlist))
endif

define link_static
$(LIBTOOL) $(slib_linkflags) $^ -o $@
endef

ifeq (yes,$(LINKCPP))
define link_dynamic
$(LIBTOOL) $(dlib_linkflags) $^ -o $@ $(liblist) $(dlib_cxxliblist)
endef
else
define link_dynamic
$(LIBTOOL) $(dlib_linkflags) $^ -o $@ $(liblist) $(dlib_cliblist)
endef
endif

ifeq (yes,$(LINKCPP))
define link_plugin
$(CXX) $(CXXFLAGS) $(TARGET_ARCH) $(plug_linkflags) $^ -o $@ $(liblist)
endef
else
define link_plugin
$(CC) $(CFLAGS) $(TARGET_ARCH) $(plug_linkflags) $^ -o $@ $(liblist)
endef
endif
