/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * engine.h
 */

#ifndef ENGINE_H
#define ENGINE_H

#include "mdapi/mdengine.h"
#include "force/force.h"
#include "simen/param.h"
#include "simen/result.h"
#include "random/random.h"

#ifdef __cplusplus
extern "C" {
#endif


  typedef struct Engine_tag {

    /* engine data arrays */
    MD_Engdata *atomprm;             /* atom force field params */
    MD_Engdata *bondprm;             /* bond force field params */
    MD_Engdata *angleprm;            /* angle force field params */
    MD_Engdata *dihedprm;            /* dihedral force field params */
    MD_Engdata *imprprm;             /* improper force field params */
    MD_Engdata *nbfixprm;            /* fix nonbonded force field params */
    MD_Engdata *atom;                /* atom topology */
    MD_Engdata *bond;                /* bond topology */
    MD_Engdata *angle;               /* angle topology */
    MD_Engdata *dihed;               /* dihedral topology */
    MD_Engdata *impr;                /* improper topology */
    MD_Engdata *excl;                /* excluded nonbonded pairs */
    MD_Engdata *pos;                 /* position array */
    MD_Engdata *vel;                 /* velocity array */
    MD_Engdata *force_engdata;       /* provides force array for "f_result" */
    MD_Engdata *result_engdata;      /* uses "result" as static buffer */
    MD_Engdata *param_engdata;       /* uses "param" as static buffer */
    MD_Engdata *timestep_engdata;    /* uses "timestep" as static buffer */
    MD_Engdata *init_temp_engdata;   /* uses "init_temp" as static buffer */
    MD_Engdata *com_motion_engdata;  /* uses "com_motion" as static buffer */
    MD_Engdata *seed_engdata;        /* uses "seed" as static buffer */
    MD_Engdata *numdegreesfreedom;   /* uses "ndegfreedom" as static buffer */

    /* declared engine-defined types */
    Result result;                   /* simulation results (e.g. energy) */
    Param param;                     /* sim params that impact force */

    /* force data */
    Force force;
    ForceResult f_result;
    ForceParam f_param;

    /* additional sim params set by front end */
    double timestep;                 /* timestep in femtoseconds */
    double init_temp;                /* initial temperature */
    char com_motion[4];              /* allow center of mass motion? */
    uint32 seed;                     /* for random number generator */

    /* additional results reported to front end */
    int32 ndegfreedom;               /* number of degrees of freedom */

    /* internal variables */
    Random random;                   /* pseudo-random number generator */
    int32 is_prng_seeded;            /* is random number seeded? */
    int32 natoms;                    /* number of atoms in system */
    double tempkonst;                /* multiply by ke for temperature */

    /* engine-define error numbers */
    int32 err_param;
    int32 err_unsupported;
    int32 err_force_init;
    int32 err_force;

  } Engine;


  /* prototypes for run and update routines */
  int32 simen_run(MD_Front *front, int32 numsteps, int32 flags);
  int32 simen_update(MD_Front *front);


#ifdef __cplusplus
}
#endif

#endif /* ENGINE_H */
