/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * split.h
 */

#ifndef SPLIT_H
#define SPLIT_H

#include <math.h>
#include "mgrid/mgrid.h"

#ifdef __cplusplus
extern "C" {
#endif


  /* constants for ERRMIN3 splitting */
#if 0
#define  MGRID_ERRMIN3_A  (-0.04465110103718)
#define  MGRID_ERRMIN3_B  (0.50895330311154)
#define  MGRID_ERRMIN3_C  (-1.38395330311154)
#define  MGRID_ERRMIN3_D  (1.91965110103718)
#endif
#define  MGRID_ERRMIN3_A  (-1./16)
#define  MGRID_ERRMIN3_B  (9./16)
#define  MGRID_ERRMIN3_C  (-23./16)
#define  MGRID_ERRMIN3_D  (31./16)

  /* constants for EXCLSW1 splitting */
#define  MGRID_EXSELF1_swdis  (1./2)
#define  MGRID_EXSELF1_A  (1./4)
#define  MGRID_EXSELF1_B  (-3./8)
#define  MGRID_EXSELF1_C  (-1./2)
#define  MGRID_EXSELF1_D  (13./8)
#define  MGRID_EXSELF1_E  (-11./16)
#define  MGRID_EXSELF1_F  (53./32)

#define  MGRID_EXSELF2_swdis  (1./3)
#define  MGRID_EXSELF2_A  (3./16)
#define  MGRID_EXSELF2_B  (-3./16)
#define  MGRID_EXSELF2_C  (-11./16)
#define  MGRID_EXSELF2_D  (27./16)
#define  MGRID_EXSELF2_E  (-3./4)
#define  MGRID_EXSELF2_F  (61./36)

#define  MGRID_EXSELF3_swdis  (1./4)
#define  MGRID_EXSELF3_A  (1./6)
#define  MGRID_EXSELF3_B  (-1./8)
#define  MGRID_EXSELF3_C  (-3./4)
#define  MGRID_EXSELF3_D  (41./24)
#define  MGRID_EXSELF3_E  (-25./32)
#define  MGRID_EXSELF3_F  (219./128)

#define  MGRID_EXSELF7_swdis  (0.5)
#define  MGRID_EXSELF7_A  (8./13)
#define  MGRID_EXSELF7_B  (-24./13)
#define  MGRID_EXSELF7_C  (24./13)
#define  MGRID_EXSELF7_D  (5./13)
#define  MGRID_EXSELF7_E  (20./13)
#define  MGRID_EXSELF7_F  (-36./13)
#define  MGRID_EXSELF7_G  (12./13)
#define  MGRID_EXSELF7_H  (-5./26)
#define  MGRID_EXSELF7_I  (-0.652713951864506)
#define  MGRID_EXSELF7_J  (1.63178487966126)



#ifdef MGRID_FAST_SPLIT

  /* define macros for inlined splitting function evaluation */

#define gamma(pg, s, split)                                                    \
  do {                                                                         \
    /* double _s = (r_a * r_a); */                                             \
    double _s = s;                                                             \
    double _g = 0;                                                             \
    switch (split) {                                                           \
      case MGRID_TAYLOR1:                                                      \
        _g = 1 + (_s-1)*(-1./2);                                               \
        break;                                                                 \
      case MGRID_TAYLOR2:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8));                               \
        break;                                                                 \
      case MGRID_TAYLOR3:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16)));             \
        break;                                                                 \
      case MGRID_TAYLOR4:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128))));                                         \
        break;                                                                 \
      case MGRID_TAYLOR5:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256)))));                     \
        break;                                                                 \
      case MGRID_TAYLOR6:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024))))));                                 \
        break;                                                                 \
      case MGRID_TAYLOR7:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048)))))));           \
        break;                                                                 \
      case MGRID_TAYLOR8:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048                   \
                        + (_s-1)*(6435./32768))))))));                         \
        break;                                                                 \
      case MGRID_ERRMIN3:                                                      \
        _g = MGRID_ERRMIN3_D + _s*(MGRID_ERRMIN3_C + _s*(MGRID_ERRMIN3_B       \
              + _s*MGRID_ERRMIN3_A));                                          \
        break;                                                                 \
      case MGRID_EXSELF1:                                                      \
        if (_s > MGRID_EXSELF1_swdis) {                                        \
          _g = MGRID_EXSELF1_D + _s*(MGRID_EXSELF1_C + _s*(MGRID_EXSELF1_B     \
                + _s*MGRID_EXSELF1_A));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF1_F + _s*MGRID_EXSELF1_E;                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF2:                                                      \
        if (_s > MGRID_EXSELF2_swdis) {                                        \
          _g = MGRID_EXSELF2_D + _s*(MGRID_EXSELF2_C + _s*(MGRID_EXSELF2_B     \
                + _s*MGRID_EXSELF2_A));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF2_F + _s*MGRID_EXSELF2_E;                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF3:                                                      \
        if (_s > MGRID_EXSELF3_swdis) {                                        \
          _g = MGRID_EXSELF3_D + _s*(MGRID_EXSELF3_C + _s*(MGRID_EXSELF3_B     \
                + _s*MGRID_EXSELF3_A));                                        \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF3_F + _s*MGRID_EXSELF3_E;                           \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF7:                                                      \
        if (_s > MGRID_EXSELF7_swdis) {                                        \
          _g = (MGRID_EXSELF7_D + _s*(MGRID_EXSELF7_C + _s*(MGRID_EXSELF7_B    \
                + _s*MGRID_EXSELF7_A))) / sqrt(_s);                            \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF7_J + _s*MGRID_EXSELF7_I;                           \
        }                                                                      \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
  } while (0)


#define dgamma(pg, pdg, s, split)                                              \
  do {                                                                         \
    /* double _s = (r_a * r_a); */                                             \
    double _s = s;                                                             \
    double _g = 0, _dg = 0;                                                    \
    switch (split) {                                                           \
      case MGRID_TAYLOR1:                                                      \
        _g = 1 + (_s-1)*(-1./2);                                               \
        _dg = -1./2;                                                           \
        break;                                                                 \
      case MGRID_TAYLOR2:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8));                               \
        _dg = -1./2 + (_s-1)*(3./4);                                           \
        break;                                                                 \
      case MGRID_TAYLOR3:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16)));             \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16));                        \
        break;                                                                 \
      case MGRID_TAYLOR4:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128))));                                         \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32)));      \
        break;                                                                 \
      case MGRID_TAYLOR5:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256)))));                     \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256))));                                       \
        break;                                                                 \
      case MGRID_TAYLOR6:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024))))));                                 \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256 + (_s-1)*(693./512)))));                   \
        break;                                                                 \
      case MGRID_TAYLOR7:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048)))))));           \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256 + (_s-1)*(693./512                         \
                    + (_s-1)*(-3003./2048))))));                               \
        break;                                                                 \
      case MGRID_TAYLOR8:                                                      \
        _g = 1 + (_s-1)*(-1./2 + (_s-1)*(3./8 + (_s-1)*(-5./16                 \
                + (_s-1)*(35./128 + (_s-1)*(-63./256                           \
                    + (_s-1)*(231./1024 + (_s-1)*(-429./2048                   \
                        + (_s-1)*(6435./32768))))))));                         \
        _dg = -1./2 + (_s-1)*(3./4 + (_s-1)*(-15./16 + (_s-1)*(35./32          \
                + (_s-1)*(-315./256 + (_s-1)*(693./512                         \
                    + (_s-1)*(-3003./2048 + (_s-1)*(6435./4096)))))));         \
        break;                                                                 \
      case MGRID_ERRMIN3:                                                      \
        _g = MGRID_ERRMIN3_D + _s*(MGRID_ERRMIN3_C + _s*(MGRID_ERRMIN3_B       \
              + _s*MGRID_ERRMIN3_A));                                          \
        _dg = MGRID_ERRMIN3_C + _s*(2*MGRID_ERRMIN3_B + _s*3*MGRID_ERRMIN3_A); \
        break;                                                                 \
      case MGRID_EXSELF1:                                                      \
        if (_s > MGRID_EXSELF1_swdis) {                                        \
          _g = MGRID_EXSELF1_D + _s*(MGRID_EXSELF1_C + _s*(MGRID_EXSELF1_B     \
                + _s*MGRID_EXSELF1_A));                                        \
          _dg = MGRID_EXSELF1_C + _s*(2*MGRID_EXSELF1_B                        \
              + _s*3*MGRID_EXSELF1_A);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF1_F + _s*MGRID_EXSELF1_E;                           \
          _dg = MGRID_EXSELF1_E;                                               \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF2:                                                      \
        if (_s > MGRID_EXSELF2_swdis) {                                        \
          _g = MGRID_EXSELF2_D + _s*(MGRID_EXSELF2_C + _s*(MGRID_EXSELF2_B     \
                + _s*MGRID_EXSELF2_A));                                        \
          _dg = MGRID_EXSELF2_C + _s*(2*MGRID_EXSELF2_B                        \
              + _s*3*MGRID_EXSELF2_A);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF2_F + _s*MGRID_EXSELF2_E;                           \
          _dg = MGRID_EXSELF2_E;                                               \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF3:                                                      \
        if (_s > MGRID_EXSELF3_swdis) {                                        \
          _g = MGRID_EXSELF3_D + _s*(MGRID_EXSELF3_C + _s*(MGRID_EXSELF3_B     \
                + _s*MGRID_EXSELF3_A));                                        \
          _dg = MGRID_EXSELF3_C + _s*(2*MGRID_EXSELF3_B                        \
              + _s*3*MGRID_EXSELF3_A);                                         \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF3_F + _s*MGRID_EXSELF3_E;                           \
          _dg = MGRID_EXSELF3_E;                                               \
        }                                                                      \
        break;                                                                 \
      case MGRID_EXSELF7:                                                      \
        if (_s > MGRID_EXSELF7_swdis) {                                        \
          _g = (MGRID_EXSELF7_D + _s*(MGRID_EXSELF7_C + _s*(MGRID_EXSELF7_B    \
                + _s*MGRID_EXSELF7_A))) / sqrt(_s);                            \
          _dg = (MGRID_EXSELF7_H + _s*(MGRID_EXSELF7_G + _s*(MGRID_EXSELF7_F   \
                + _s*MGRID_EXSELF7_E))) / (_s*sqrt(_s));                       \
        }                                                                      \
        else {                                                                 \
          _g = MGRID_EXSELF7_J + _s*MGRID_EXSELF7_I;                           \
          _dg = MGRID_EXSELF7_I;                                               \
        }                                                                      \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
    /* *(pdg) = _dg * (2.0 * r_a); */                                          \
    *(pdg) = _dg;                                                              \
  } while (0)


#define gamma_odd(pg, r, split)                                                \
  do {                                                                         \
    double _r = r;                                                             \
    double _r2 = _r*_r;                                                        \
    double _g = 0;                                                             \
    switch (split) {                                                           \
      case MGRID_ODDPR1:                                                       \
        _g = 3./2 + _r2*(-1./2);                                               \
        break;                                                                 \
      case MGRID_ODDPR2:                                                       \
        _g = 2 + _r2*(-2 + _r);                                                \
        break;                                                                 \
      case MGRID_ODDPR3:                                                       \
        _g = 9./4 + _r2*(-5./2 + _r2*(9./4 - _r));                             \
        break;                                                                 \
      case MGRID_ODDPR4:                                                       \
        _g = 21./8 + _r2*(-35./8 + _r2*(63./8 + _r*(-7 + _r*(15./8))));        \
        break;                                                                 \
      case MGRID_ODDPR5:                                                       \
        _g = 45./16 + _r2*(-21./4 + _r2*(63./8 + _r2*(-45./4                   \
                + _r*(9 + _r*(-35./16)))));                                    \
        break;                                                                 \
      case MGRID_ODDPR6:                                                       \
        _g = 25./8 + _r2*(-15./2 + _r2*(63./4 + _r2*(-75./2                    \
                + _r*(45 + _r*(-175./8 + _r*4)))));                            \
        break;                                                                 \
      case MGRID_ODDPR7:                                                       \
        _g = 105./32 + _r2*(-275./32 + _r2*(297./16 + _r2*(-495./16            \
                + _r2*(1925./32 + _r*(-66 + _r*(945./32 + _r*(-5)))))));       \
        break;                                                                 \
      case MGRID_ODDPR8:                                                       \
        _g = 455./128 + _r2*(-715./64 + _r2*(3861./128 + _r2*(-2145./32        \
                + _r2*(25025./128 + _r*(-286 + _r*(12285./64 + _r*(-65         \
                        + _r*(1155./128))))))));                               \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
  } while (0)


#define dgamma_odd(pg, pdg, r, split)                                          \
  do {                                                                         \
    double _r = r;                                                             \
    double _r2 = _r*_r;                                                        \
    double _g = 0, _dg = 0;                                                    \
    switch (split) {                                                           \
      case MGRID_ODDPR1:                                                       \
        _g = 3./2 + _r2*(-1./2);                                               \
        _dg = -_r;                                                             \
        break;                                                                 \
      case MGRID_ODDPR2:                                                       \
        _g = 2 + _r2*(-2 + _r);                                                \
        _dg = _r*(-4 + _r*3);                                                  \
        break;                                                                 \
      case MGRID_ODDPR3:                                                       \
        _g = 9./4 + _r2*(-5./2 + _r2*(9./4 - _r));                             \
        _dg = _r*(-5 + _r2*(9 + _r*(-5)));                                     \
        break;                                                                 \
      case MGRID_ODDPR4:                                                       \
        _g = 21./8 + _r2*(-35./8 + _r2*(63./8 + _r*(-7 + _r*(15./8))));        \
        _dg = _r*(-35./4 + _r2*(63./2 + _r*(-35 + _r*(45./4))));               \
        break;                                                                 \
      case MGRID_ODDPR5:                                                       \
        _g = 45./16 + _r2*(-21./4 + _r2*(63./8 + _r2*(-45./4                   \
                + _r*(9 + _r*(-35./16)))));                                    \
        _dg = _r*(-21./2 + _r2*(63./2 + _r2*(-135./2                           \
                + _r*(63 + _r*(-35./2)))));                                    \
        break;                                                                 \
      case MGRID_ODDPR6:                                                       \
        _g = 25./8 + _r2*(-15./2 + _r2*(63./4 + _r2*(-75./2                    \
                + _r*(45 + _r*(-175./8 + _r*4)))));                            \
        _dg = _r*(-15 + _r2*(63 + _r2*(-225                                    \
                + _r*(315 + _r*(-175 + _r*36)))));                             \
        break;                                                                 \
      case MGRID_ODDPR7:                                                       \
        _g = 105./32 + _r2*(-275./32 + _r2*(297./16 + _r2*(-495./16            \
                + _r2*(1925./32 + _r*(-66 + _r*(945./32 + _r*(-5)))))));       \
        _dg = _r*(-275./16 + _r2*(297./4 + _r2*(-1485./8                       \
                + _r2*(1925./4 + _r*(-594 + _r*(4725./16 + _r*(-55)))))));     \
        break;                                                                 \
      case MGRID_ODDPR8:                                                       \
        _g = 455./128 + _r2*(-715./64 + _r2*(3861./128 + _r2*(-2145./32        \
                + _r2*(25025./128 + _r*(-286 + _r*(12285./64 + _r*(-65         \
                        + _r*(1155./128))))))));                               \
        _dg = _r*(-715./32 + _r2*(3861./32 + _r2*(-6435./16                    \
                + _r2*(25025./16 + _r*(-2574 + _r*(61425./32 + _r*(-715        \
                        + _r*(3465./32))))))));                                \
        break;                                                                 \
    }                                                                          \
    *(pg) = _g;                                                                \
    *(pdg) = _dg;                                                              \
  } while (0)


#else

  /* otherwise call externally linked functions */
  void mgrid_gamma(double *pg, double s, int32 split);
  void mgrid_dgamma(double *pg, double *pdg, double s, int32 split);

#define gamma  mgrid_gamma
#define dgamma  mgrid_dgamma

  void mgrid_gamma_odd(double *pg, double r, int32 split);
  void mgrid_dgamma_odd(double *pg, double *pdg, double r, int32 split);

#define gamma_odd  mgrid_gamma_odd
#define dgamma_odd  mgrid_dgamma_odd

#endif

  /* compute all derivatives of splitting up to n-1, store in array */
  void mgrid_ndgamma(double *pg, int32 n, double s, int32 split);

#ifdef __cplusplus
}
#endif

#endif /* SPLIT_H */
