/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * hermite.h
 */

#ifndef HERMITE_H
#define HERMITE_H

#ifdef __cplusplus
extern "C" {
#endif


  /*
   * grid point "vector" for Hermite interpolation
   *
   * this can (when convenient) be accessed as 8-element vector
   *
   * index value "1" corresponds to some partial deriv in x, y, or z,
   * respectively
   */
  typedef struct HermGridpt_tag {
    double d000;
    double d100;
    double d010;
    double d001;
    double d110;
    double d101;
    double d011;
    double d111;
  } HermGridpt;


  /*
   * grid point interaction "matrix" for Hermite interpolation
   *
   * this can (when convenient) be accessed as 8-by-8 element matrix
   * stored in row-major column ordering
   */
  typedef struct HermDirect_tag {
    double d000_000, d000_100, d000_010, d000_001,
           d000_110, d000_101, d000_011, d000_111;
    double d100_000, d100_100, d100_010, d100_001,
           d100_110, d100_101, d100_011, d100_111;
    double d010_000, d010_100, d010_010, d010_001,
           d010_110, d010_101, d010_011, d010_111;
    double d001_000, d001_100, d001_010, d001_001,
           d001_110, d001_101, d001_011, d001_111;
    double d110_000, d110_100, d110_010, d110_001,
           d110_110, d110_101, d110_011, d110_111;
    double d101_000, d101_100, d101_010, d101_001,
           d101_110, d101_101, d101_011, d101_111;
    double d011_000, d011_100, d011_010, d011_001,
           d011_110, d011_101, d011_011, d011_111;
    double d111_000, d111_100, d111_010, d111_001,
           d111_110, d111_101, d111_011, d111_111;
  } HermDirect;


#ifdef __cplusplus
}
#endif

#endif /* HERMITE_H */
