/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * system.h
 */

#ifndef SYSTEM_H
#define SYSTEM_H

#include "mdapi/mdfront.h"
#include "mdio/mdio.h"

#ifdef __cplusplus
extern "C" {
#endif

  /* need a forward definition of SimParam type */
  struct SimParam_tag;

  /*
   * maintain system data from this structure
   */
  typedef struct System_tag {

    MD_Engine *eng;            /* points to engine interface object */

    /*** engine interface data ***/

    int32 atomprm_id;          /* engine data array ID numbers */
    int32 bondprm_id;
    int32 angleprm_id;
    int32 dihedprm_id;
    int32 imprprm_id;
    int32 nbfixprm_id;
    int32 atom_id;
    int32 bond_id;
    int32 angle_id;
    int32 dihed_id;
    int32 impr_id;
    int32 excl_id;
    int32 pos_id;
    int32 vel_id;
    int32 result_id;
    MD_Attrib atomprm_attr;    /* engine data array attributes */
    MD_Attrib bondprm_attr;
    MD_Attrib angleprm_attr;
    MD_Attrib dihedprm_attr;
    MD_Attrib imprprm_attr;
    MD_Attrib nbfixprm_attr;
    MD_Attrib atom_attr;
    MD_Attrib bond_attr;
    MD_Attrib angle_attr;
    MD_Attrib dihed_attr;
    MD_Attrib impr_attr;
    MD_Attrib excl_attr;
    MD_Attrib pos_attr;
    MD_Attrib vel_attr;
    MD_Attrib result_attr;

    /*** MDIO file reader objects ***/

    mdio_Param prm;            /* arrays below point to their data */
    mdio_Topo topo;
    mdio_Pdbcoord pdb;
    mdio_Pdbcoord pdbvel;
    mdio_Bincoord bin;
    mdio_Bincoord binvel;

    /*** system data for initialization ***/

    /* force field parameters */
    int32 atomprm_len;         /* lengths of arrays (below) */
    int32 bondprm_len;
    int32 angleprm_len;
    int32 dihedprm_len;
    int32 imprprm_len;
    int32 nbfixprm_len;
    MD_AtomPrm *atomprm;       /* arrays */
    MD_BondPrm *bondprm;
    MD_AnglePrm *angleprm;
    MD_TorsPrm *dihedprm;
    MD_TorsPrm *imprprm;
    MD_NbfixPrm *nbfixprm;

    /* topology */
    int32 atom_len;            /* number of atoms */
    int32 bond_len;            /* and lengths of arrays (below) */
    int32 angle_len;
    int32 dihed_len;
    int32 impr_len;
    int32 excl_len;
    MD_Atom *atom;             /* arrays */
    MD_Bond *bond;
    MD_Angle *angle;
    MD_Tors *dihed;
    MD_Tors *impr;
    MD_Excl *excl;

    /* trajectory - length is given by "atom_len" */
    MD_Dvec *pos;              /* arrays */
    MD_Dvec *vel;

    mdio_Pdbatom *pdbatompos;  /* extra info needed to write pos PDB files */
    mdio_Pdbatom *pdbatomvel;  /* extra info needed to write vel PDB files */

    MD_Dvec *posbuf;           /* extra buffers might be needed */
    MD_Dvec *velbuf;
    void *resultbuf;

    int32 is_vel_alloc;        /* is vel array independently allocated? */
  } System;

  /* prototypes */
  int system_init(System *);
  int system_setup(System *, MD_Engine *);
  int system_input(System *, struct SimParam_tag *);
  void system_done(System *);

#ifdef __cplusplus
}
#endif

#endif /* SYSTEM_H */
