/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * sim.h
 */

#ifndef SIM_H
#define SIM_H

#include "adt/list.h"
#include "mdio/mdio.h"
#include "mdsim/simparam.h"
#include "mdsim/engparam.h"
#include "mdsim/system.h"
#include "mdsim/callback.h"

#ifdef __cplusplus
extern "C" {
#endif

  /*
   * maintain simulation data from this structure
   */
  typedef struct Sim_tag {
    MD_Engine engine;       /* engine interface */

    mdio_Config cfg;        /* for config file param parsing */
    mdio_ConfigData *info;
    int32 info_len;

    adt_List keyword;       /* list of keywords converted to lower case */

    SimParam simparam;      /* front end simulation parameters */
    EngParam engparam;      /* engine simulation parameters */
    System system;          /* system data arrays */
    Callback callback;      /* for callbacks */
  } Sim;

  /* prototypes */
  int sim_init(Sim *);
  int sim_input_configfile(Sim *, int cfg_argc, char *cfg_argv[]);
  int sim_start_engine(Sim *);
  int sim_parse_configfile(Sim *);
  int sim_input_sysdata(Sim *);
  int sim_setup_callbacks(Sim *);
  int sim_run(Sim *);
  int sim_output_sysdata(Sim *);
  void sim_done(Sim *);

#ifdef __cplusplus
}
#endif

#endif /* SIM_H */
