/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * error.h
 */

#ifndef ERROR_H
#define ERROR_H

#include "mdio/file.h"

#ifdef __cplusplus
extern "C" {
#endif

  /* error constants */
  enum {

    /*** general error ***/
    FAIL = -1,         /* indicates failure of routine */

    /*** specific errors ***/
    NOTFOUND = 0x001,  /* keyword not found in table */
    NOTPARAM = 0x002,  /* keyword is not a simulation parameter */
    REINIT = 0x004,    /* attempt to reinitialize a simulation parameter */
    BADVAL = 0x008,    /* attempt to assign an illegal value */
    TRUNC = 0x010      /* string value must be truncated to fit storage */
  };

  /*
   * error(msg) - prints msg to stderr using printf formatting,
   *   terminates program (returns FAIL)
   */
  int error(const char *fmt, ...);

  /*
   * warn(msg) - prints msg to stdout using printf formatting,
   *   returns FAIL
   */
  int warn(const char *fmt, ...);

  /* error messages */
#define MSG \
  "(%s,%d): %s", __FILE__, __LINE__

#define MSG_NOMEM \
  "(%s,%d): cannot allocate memory", __FILE__, __LINE__

#define MSG_ENGINE \
  "(%s,%d): engine bug: %s", __FILE__, __LINE__

#define MSG_MDAPI \
  "(%s,%d): unexpected MDAPI error %s: %s", __FILE__, __LINE__

#define MSG_MDIO \
  "(%s,%d): MDIO %s", __FILE__, __LINE__

  /* error handler to be called by MDIO */
  int mdio_errhandler(mdio_File *);

#ifdef __cplusplus
}
#endif

#endif /* ERROR_H */
