/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * error.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "mdsim/error.h"

/*
 * errors are fatal
 * send message to standard error stream
 * terminate program
 */
int error(const char *fmt, ...)
{
  FILE *f = stderr;
  va_list(ap);

  /* always start error messages on their own line */
  fprintf(f, "\nERROR: ");
  va_start(ap, fmt);
  vfprintf(f, fmt, ap);
  va_end(ap);
  fprintf(f, "\n");
  exit(1);
  return FAIL;
}

/*
 * warnings are not fatal
 * send message to standard output stream
 * returns FAIL
 */
int warn(const char *fmt, ...)
{
  FILE *f = stdout;
  va_list(ap);

  /* always start warning messages on their own line */
  fprintf(f, "\nWARNING: ");
  va_start(ap, fmt);
  vfprintf(f, fmt, ap);
  va_end(ap);
  fprintf(f, "\n");
  return FAIL;
}

/*
 * handle MDIO warnings (e.g. redefined force field parameters)
 * immediately so that they don't get lost
 */
int mdio_errhandler(mdio_File *f)
{
  int errnum;
  errnum = mdio_getErrorFile(f);
  if (MDIO_ERROR_WARN == errnum) {
    warn("MDIO %s", mdio_getErrorMessageFile(f));
  }
  return errnum;
}
