/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * callback.h
 */

#ifndef CALLBACK_H
#define CALLBACK_H

#include "mdio/mdio.h"
#include "mdapi/mdfront.h"
#include "mdsim/simparam.h"
#include "mdsim/system.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct Callback_tag {
    SimParam *sp;
    System *sys;

    /* for restart files */
    int32 is_restart;
    int32 is_binary;
    MD_Dvec *vel;
    mdio_Bincoord bin;
    mdio_Pdbcoord pdb;
    MD_Cbdata restart[2];

    /* for either position or velocity DCD file */
    void *param_obj;
    double timestep;
    mdio_DcdCell cell;
    int32 with_result;
    int32 offset_cellvec1;
    int32 offset_cellvec2;
    int32 offset_cellvec3;

    /* for position DCD file */
    int32 is_posdcd;
    mdio_Dcd posdcd;
    MD_Cbdata cbposdcd[2];

    /* for velocity DCD file */
    int32 is_veldcd;
    mdio_Dcd veldcd;
    MD_Cbdata cbveldcd[2];

    /* for results */
    int32 is_results;
    int32 cnt;
    int32 results_info_len;
    ResultsInfo *results_info;
    FILE *logfile;
    MD_Cbdata results[1];

  } Callback;

  /* prototypes */
  int callback_init(Callback *);
  int callback_setup(Callback *, MD_Engine *e, SimParam *p, System *s);
  int callback_setup_restart(Callback *);
  int callback_setup_posdcd(Callback *);
  int callback_setup_veldcd(Callback *);
  int callback_setup_results(Callback *);
  void callback_done(Callback *);

  /* callback routines */
  int32 callback_restart(void *, MD_Cbdata *, int32, int32);
  int32 callback_posdcd(void *, MD_Cbdata *, int32, int32);
  int32 callback_veldcd(void *, MD_Cbdata *, int32, int32);
  int32 callback_results(void *, MD_Cbdata *, int32, int32);

#ifdef __cplusplus
}
#endif

#endif /* CALLBACK_H */
