/*
 * Copyright (C) 2003-2004 by David J. Hardy.  All rights reserved.
 *
 * mddef.h - internal header, prototypes for functions not in API
 */

#ifndef MDDEF_H
#define MDDEF_H

#include "mdapi/mdfront.h"
#include "mdapi/mdengine.h"

#ifdef __cplusplus
extern "C" {
#endif

  /*
   * store type information in MD_Interface "typinfo"
   * one per type
   */
  typedef struct TypeInfo_tag {
    int32 typnum;
    const char *typname;
    const MD_Member *memberlist;
    int32 memberlistlen;
    adt_Table *member;  /* create table on first call to MD_type_member() */
    int32 *byteoffset;  /* created by MD_type_member(), length memberlistlen */
    int32 *flipoffset;
    int32 flipoffsetlen;
  } TypeInfo;

  /* 
   * store callback data in MD_Interface "msgcb"
   * one per message callback
   */
  typedef struct MsgcbInfo_tag {
    int32 (*msgcb)(void *, const char *msg, int32 stepnum);
                        /* points to message callback routine */
    void *info;         /* points to front end specific info */
  } MsgcbInfo;


/*** for error subsystem ***/

  int32 MD_error_version(MD_Interface *);
  /*
   * Called by MD_init_version() or MD_setup_engine_version() to
   * set MD_ERR_VERSION error.
   *
   * Returns MD_FAIL.
   *
   * Error states:
   *   MD_ERR_VERSION - inconsistent version number
   *
   * In the event that the version number check fails, we must set
   * MD_ERR_VERSION here (rather than MD_error()) because we cannot
   * trust the length of MD_Interface structure.
   */

  int32 MD_init_error(MD_Interface *);
  /*
   * Called by MD_init_version() to initialize error subsystem.
   *
   * Returns 0 on success or MD_FAIL on error.
   *
   * Error states:
   *   MD_ERR_MEMALLOC - memory cannot be allocated
   */

  void MD_done_error(MD_Interface *);
  /*
   * Called by MD_done() to cleanup error subsystem.
   */


/*** for types subsystem ***/

  int32 MD_init_types(MD_Interface *);
  /*
   * Called by MD_init_version() to initialize types subsystem.
   *
   * Returns 0 on success of MD_FAIL on error.
   *
   * Error states:
   *   MD_ERR_MEMALLOC - memory cannot be allocated
   */

  void MD_done_types(MD_Interface *);
  /*
   * Called by MD_done() to cleanup types subsystem.
   */

  int32 MD_flipdata(MD_Interface *, void *vbuf, int32 nelems, int32 typnum);
  /*
   * Reverses byte ordering on array of some defined data type.
   *
   *   vbuf - points to array buffer
   *   nelems - number of array elements
   *   typnum - indicates defined type
   *
   * Byte swapping is done in place.  Returns 0 on success or MD_FAIL on
   * error.
   *
   * Error states:
   *   MD_ERR_TYPENUM - invalid type number
   */


/*** for data subsystem ***/

  int32 MD_init_data(MD_Interface *);
  /*
   * Called by MD_init_version() to initialize data subsystem.
   *
   * Returns 0 on success of MD_FAIL on error.
   *
   * Error states:
   *   MD_ERR_MEMALLOC - memory cannot be allocated
   */

  void MD_done_data(MD_Interface *);
  /*
   * Called by MD_done() to cleanup data subsystem.
   */

  void MD_clear_update(MD_Interface *);
  /*
   * Called internally at end of MD_run().
   *
   * Clear MD_UPDATE global flag if all modified buffers that engine
   * was notified about have been acknowledged through an engine call
   * to MD_engdata_ackmod() on the buffer.
   */


/*** for callback subsystem ***/

  int32 MD_init_callback(MD_Interface *);
  /*
   * Called by MD_init_version() to initialize callback subsystem.
   *
   * Returns 0 on success of MD_FAIL on error.
   *
   * Error states:
   *   MD_ERR_MEMALLOC - memory cannot be allocated
   */

  void MD_done_callback(MD_Interface *);
  /*
   * Called by MD_done() to cleanup callback subsystem.
   */

#ifdef __cplusplus
}
#endif

#endif /* MDDEF_H */
