/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * param.h
 */

#ifndef PARAM_H
#define PARAM_H

#include "mdapi/mdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct Param_tag {
    double cutoff;
    double switchDist;
    char switching[4];
    char exclude[12];
    double dielectric;
    double scaling;
    char fullDirect[4];
    char sphericalBC[4];
    MD_Dvec sphericalBCCenter;
    double sphericalBCr1;
    double sphericalBCr2;
    double sphericalBCk1;
    double sphericalBCk2;
    int32 sphericalBCexp1;
    int32 sphericalBCexp2;
    char cylindricalBC[4];
    char cylindricalBCAxis[4];
    MD_Dvec cylindricalBCCenter;
    double cylindricalBCr1;
    double cylindricalBCr2;
    double cylindricalBCl1;
    double cylindricalBCl2;
    double cylindricalBCk1;
    double cylindricalBCk2;
    int32 cylindricalBCexp1;
    int32 cylindricalBCexp2;
    MD_Dvec cellBasisVector1;
    MD_Dvec cellBasisVector2;
    MD_Dvec cellBasisVector3;
    MD_Dvec cellOrigin;
  /*** mgrid params ***/
    char mgrid[8];
    double mgridLength;
    double mgridCutoff;
    double mgridSpacing;
    int32 mgridNspacings;
    int32 mgridNlevels;
    char mgridApprox[12];
    char mgridSplit[12];
  } Param;

#ifdef __cplusplus
}
#endif

#endif /* PARAM_H */
