/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * force.c
 */

#include <stdio.h>
#include <stdlib.h>
#include "mdapi/mdengine.h"
#include "force/force.h"
#include "mgrid/mgrid.h"
#include "deven/engine.h"
#include "debug/debug.h"


/* called from step_compute() */
int32 deven_force(void *vfront, MD_Dvec *f, MD_Dvec *pos)
{
  MD_Front *front = (MD_Front *) vfront;
  Engine *eng = (Engine *) MD_engine_data(front);
  Force *force = &(eng->force);
/*** data for mgrid ***/
  Mgrid *mgrid = &(eng->mgrid);
  MgridSystem *mgrid_system = &(eng->mgrid_system);
  MD_Dvec *wrap = (MD_Dvec *) (eng->wrap->buf);
  MD_Dvec *poswrap = (MD_Dvec *) (eng->poswrap->buf);
  MD_Dvec *f_elec = (MD_Dvec *) (eng->f_elec->buf);
#if 0
  MD_Dvec *force_elec = (MD_Dvec *) (eng->force_elec->buf);
#endif
/*** end data for mgrid ***/
  int32 natoms = eng->natoms;
  int32 k;

  if ( ! eng->ismgrid) {
    /* evaluate all forces using force library */
    /* array f updated implicitly */
    if (force_compute(force, pos, NULL)) {
      return MD_error(front, eng->err_force);
    }
#if 0
    printf("force 0:  %g %g %g\n", force_elec[0].x, force_elec[0].y,
        force_elec[0].z);
#endif
  }
  else {
    /* evaluate all forces except for electrostatic */
    /* array f updated implicitly */
    if (force_compute(force, pos, wrap)) {
      return MD_error(front, eng->err_force);
    }
    /* wrap positions back into periodic cell for mgrid */
    for (k = 0;  k < natoms;  k++) {
      poswrap[k].x = pos[k].x + wrap[k].x;
      poswrap[k].y = pos[k].y + wrap[k].y;
      poswrap[k].z = pos[k].z + wrap[k].z;
    }
    /* be paranoid, make sure that atoms are inside mgrid domain */
    if ((k = mgrid_system_validate(mgrid, mgrid_system)) < natoms) {
      printf("# mgrid system validation failed for atom k=%d\n", k);
      printf("# poswrap[%d] =  %g %g %g\n", k, poswrap[k].x, poswrap[k].y,
          poswrap[k].z);
      printf("# pos[%d] =  %g %g %g\n", k, pos[k].x, pos[k].y, pos[k].z);
      printf("# wrap[%d] =  %g %g %g\n", k, wrap[k].x, wrap[k].y, wrap[k].z);
      return MD_error(front, eng->err_force);
    }
    /* compute mgrid (mgrid_system has poswrap and sets f_elec) */
    if (mgrid_force(mgrid, mgrid_system)) {
      return MD_error(front, eng->err_force);
    }
    /* adjust force using mgrid elec results */
    /* accumulate electrostatic forces into array f */
    for (k = 0;  k < natoms;  k++) {
      f[k].x += f_elec[k].x;
      f[k].y += f_elec[k].y;
      f[k].z += f_elec[k].z;
    }
#if 0
    printf("mgrid 0:  %g %g %g\n", f_elec[0].x, f_elec[0].y, f_elec[0].z);
    printf("force 0:  %g %g %g\n", f_elec[0].x + force_elec[0].x,
        f_elec[0].y + force_elec[0].y, f_elec[0].z + force_elec[0].z);
#endif
  }
  return 0;
}
