/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * engine.h
 */

#ifndef ENGINE_H
#define ENGINE_H

#include "mdapi/mdengine.h"
#include "force/force.h"
#include "mgrid/mgrid.h"
#include "step/step.h"
#include "deven/param.h"
#include "deven/result.h"

#ifdef __cplusplus
extern "C" {
#endif


  typedef struct Engine_tag {

    /* engine data arrays */
    MD_Engdata *atomprm;             /* atom force field params */
    MD_Engdata *bondprm;             /* bond force field params */
    MD_Engdata *angleprm;            /* angle force field params */
    MD_Engdata *dihedprm;            /* dihedral force field params */
    MD_Engdata *imprprm;             /* improper force field params */
    MD_Engdata *nbfixprm;            /* fix nonbonded force field params */
    MD_Engdata *atom;                /* atom topology */
    MD_Engdata *bond;                /* bond topology */
    MD_Engdata *angle;               /* angle topology */
    MD_Engdata *dihed;               /* dihedral topology */
    MD_Engdata *impr;                /* improper topology */
    MD_Engdata *excl;                /* excluded nonbonded pairs */
    MD_Engdata *pos;                 /* position array */
    MD_Engdata *vel;                 /* velocity array */
    MD_Engdata *force_engdata;       /* provides force array for "f_result" */
    MD_Engdata *result_engdata;      /* uses "result" as static buffer */
    MD_Engdata *param_engdata;       /* uses "param" as static buffer */
    MD_Engdata *timestep_engdata;    /* uses "timestep" as static buffer */
    MD_Engdata *init_temp_engdata;   /* uses "init_temp" as static buffer */
    MD_Engdata *com_motion_engdata;  /* uses "com_motion" as static buffer */
    MD_Engdata *seed_engdata;        /* uses "seed" as static buffer */
    MD_Engdata *numdegreesfreedom;   /* uses "ndegfreedom" as static buffer */
  /*** data arrays for mgrid ***/
    MD_Engdata *wrap;                /* wrapping for periodic boundaries */
    MD_Engdata *poswrap;             /* positions offset by wrapping */
    MD_Engdata *f_elec;              /* provides f_elec for mgrid_system */
    MD_Engdata *charge;              /* provides charge for mgrid_system */
#if 0
  /*** for debugging electrostatics ***/
    MD_Engdata *force_elec;
#endif

    /* declared engine-defined types */
    Result result;                   /* simulation results (e.g. energy) */
    Param param;                     /* sim params that impact force */

    /* force data */
    Force force;
    ForceResult f_result;
    ForceParam f_param;

    /* mgrid data */
    int32 ismgrid;
    Mgrid mgrid;
    MgridParam mgrid_param;
    MgridSystem mgrid_system;

    /* step data */
    Step step;
    StepParam step_param;
    StepSystem step_system;
    int32 is_step_initialized;

    /* additional sim params set by front end */
    double timestep;                 /* timestep in femtoseconds */
    double init_temp;                /* initial temperature */
    char com_motion[4];              /* allow center of mass motion? */
    uint32 seed;                     /* for random number generator */

    /* additional results reported to front end */
    int32 ndegfreedom;               /* number of degrees of freedom */

    /* internal variables */
    int32 natoms;                    /* number of atoms in system */

    /* engine-define error numbers */
    int32 err_param;
    int32 err_unsupported;
    int32 err_force_init;
    int32 err_force;

  } Engine;


  /* prototypes for run, update, and force routines */
  int32 deven_run(MD_Front *front, int32 numsteps, int32 flags);
  int32 deven_update(MD_Front *front);
  int32 deven_force(void *vfront, MD_Dvec *f, MD_Dvec *pos);


#ifdef __cplusplus
}
#endif

#endif /* ENGINE_H */
