/*
 * Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
 *
 * demo_debug.c - demonstrate use of debug.h
 */

#include <stdio.h>
#include <unistd.h>

/*
 * include debug support by default, but allow compilation option
 * to turn it off
 */
#ifndef DEBUG_OFF
#undef DEBUG_SUPPORT
#define DEBUG_SUPPORT
#undef DEBUG_WATCH
#define DEBUG_WATCH
#endif
#include "debug/debug.h"

typedef struct Vec_t { double x, y, z; } Vec;

int main(int argc, char **argv)
{
  const char *str = "hello, dave";
  int n = 42;
  Vec u = { 1, 2, 3 };
  int c;
  void *m;
  extern int optind;

  c = getopt(argc, argv, "ace");
  switch (c) {
    case 'a':
      /*
       * a false assertion will cause program abort
       */
      ASSERT(0 == 0);
      ASSERT(0 == 1);
      break;
    case 'c':
      /*
       * a true exceptional condition will also cause program abort
       * (the opposite of ASSERT)
       */
      COND(0 == 1);
      COND(1 == 1);
      break;
    case 'e':
      /*
       * a true exceptional condition will cause program termination
       * plus system error message
       */
      ERRCOND( (m = malloc(sizeof(int))) == NULL );
      ERRCOND( fopen("not_a_file", "r") == NULL );
      break;
    case -1:
      /* no valid command line args */
      break;
    default:
      ERRCOND( c != 'a' && c != 'c' && c != 'e' && c != -1 );
      fprintf(stderr, "found an invalid command line arg\n");
      exit(1);
  }
  if (optind < argc) {
    COND(optind < argc);
    fprintf(stderr, "extra command line args are invalid\n");
    exit(1);
  }

  TEXT("string literal");
  STR(str);
  PTR(str);
  str = NULL;
  STR(str);
  PTR(str);
  PTR(NULL);
  INT(n);
  FLT(u.x / 3.0);
  VEC(u);

  fprintf(stderr, "all done!\n");
  return 0;
}
