/*
 * Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
 *
 * demo_list.c
 */

#include <stdio.h>
#include "adt/list.h"
#include "debug/debug.h"

/* print list of integers */
int print_list(adt_List *list)
{
  int k;
  int len = adt_getLengthList(list);
  int *data = (int *) adt_getDataList(list);
  for (k = 0;  k < len;  k++) {
    printf(" %d", data[k]);
  }
  printf("\n");
  return 0;
}


int main(void)
{
  int k;
  adt_List *list;
  list = adt_createList(sizeof(int), 0, NULL);
  if (list == NULL) {
    BUG("cannot create list");
  }
  printf("%2d:", adt_getLengthList(list));
  print_list(list);
  for (k = 1;  k <= 28;  k++) {
    if (adt_appendList(list, &k)) {
      BUG("cannot append element to list");
    }
    printf("%2d:", adt_getLengthList(list));
    print_list(list);
  }
  while (adt_getLengthList(list) > 0) {
    if (adt_deleteList(list)) {
      BUG("cannot delete element from list");
    }
    printf("%2d:", adt_getLengthList(list));
    print_list(list);
  }
  return 0;
}
