#
# Copyright (C) 2003-2005 by David J. Hardy.  All rights reserved.
#
# architecture dependent file for building on Darwin (Mac OS X)
# (flags set for GNU compilers - debug version)
 
# used in gnu make implicit rules
LIBTOOL := libtool 
CC := cc
CXX := c++
CPPFLAGS := -DMDX_DARWIN -D_GNU_SOURCE -DDEBUG_SUPPORT -I$(srcdir) -I- -Wall -pedantic
CFLAGS := -O0 -ggdb -std=c99
CXXFLAGS := -O0 -ggdb -std=c++98
TARGET_ARCH :=
LDFLAGS :=
LOADLIBES :=
LDLIBS :=

# flags for computing dependencies
DEPFLAGS := -MM 

# definitions for linking static libraries
slib_name := lib$(NAME).a
slib_linkflags := -static -L$(libdir)

# definitions for linking dynamic libraries
dlib_name := lib$(NAME).dylib
dlib_flags := -fPIC -dynamic
dlib_linkflags := -dynamic -L$(libdir)
dlib_linkflags += -install_name $(INSTALL_LIB)/$(dlib_name)
dlib_cliblist := -lc -lcc_dynamic
dlib_cxxliblist := -lstdc++ -lc -lcc_dynamic

# definitions for linking plugins (dynamically loadable modules)
plug_name := $(NAME).bundle
plug_flags := -fPIC -shared -dynamic
plug_linkflags := -bundle

# definitions for linking binary executables
bin_name := $(NAME)
bin_linkflags := -L$(libdir)

# extra link options needed for optional libraries
ifneq (,$(strip $(filter-out $(libdir),$(optlib_dirlist))))
dlib_linkflags += $(addprefix -L,$(optlib_dirlist))
#plug_linkflags += $(addprefix -L,$(optlib_dirlist))
bin_linkflags += $(addprefix -L,$(optlib_dirlist))
endif

define link_static
$(LIBTOOL) $(slib_linkflags) $^ -o $@
endef

ifeq (yes,$(LINKCPP))
define link_dynamic
$(LIBTOOL) $(dlib_linkflags) $^ -o $@ $(liblist) $(dlib_cxxliblist)
endef
else
define link_dynamic
$(LIBTOOL) $(dlib_linkflags) $^ -o $@ $(liblist) $(dlib_cliblist)
endef
endif

ifeq (yes,$(LINKCPP))
define link_plugin
$(CXX) $(CXXFLAGS) $(TARGET_ARCH) $(plug_linkflags) $^ -o $@ $(liblist)
endef
else
define link_plugin
$(CC) $(CFLAGS) $(TARGET_ARCH) $(plug_linkflags) $^ -o $@ $(liblist)
endef
endif
