/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2001 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: utilities.C,v $
 *	$Author: saam $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 2003/07/26 09:57:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * General utility routines and definitions.
 *
 ***************************************************************************/

#include <iostream.h>
#include <string.h>
#include <ctype.h>  // toupper()
#include <math.h>
#include <stdio.h>
#ifdef DMALLOC
#include <dmalloc.h>
#endif

#if defined(_MSC_VER)
#include <windows.h>
#include <conio.h>
#else
//#include <unistd.h>
//#include <sys/time.h>

#if defined(ARCH_AIX4)
#include <strings.h>
#endif

#if defined(ARCH_IRIX5) || defined(ARCH_IRIX6) || defined(ARCH_IRIX6_64)
#include <bstring.h>
#endif

#if defined(ARCH_HPUX9) || defined(ARCH_HPUX10) || defined(ARCH_HPUX11)
#include <time.h>
#endif // HPUX
#endif // _MSC_VER

#ifndef ARCH_LINUX
#define acosf acos
#define sqrtf sqrt
#endif

#include "utilities.h"

// given an argc, argv pair, take all the arguments from the Nth one on
// and combine them into a single string with spaces separating words.  This
// allocates space for the string, which must be freed by the user.
char *combine_arguments(int argc, char **argv, int n) {
  char *newstr = NULL;

  if(argc > 0 && n < argc && n >= 0) {
    int i, sl = 0;
    // find out the length of the words we must combine
    for(i=n; i < argc; i++)
      sl += strlen(argv[i]);

    // combine the words together
    if(sl) {
      newstr = new char[sl + 8 + argc - n];	// extra buffer added
      *newstr = '\0';
      for(i=n; i < argc; i++) {
        if(i != n)
          strcat(newstr," ");
        strcat(newstr, argv[i]);
      }
    }
  }

  // return the string, or NULL if a problem occurred
  return newstr;
}


// duplicate a string using c++ new call
char *stringdup(const char *s) {
  char *rs;

  if(!s)
    return NULL;

  rs = new char[strlen(s) + 1];
  strcpy(rs,s);

  return rs;
}


// convert a string to upper case
char *stringtoupper(char *s) {
  register int i;

  if(s) {
    for(i=(strlen(s) - 1); i >= 0; i--)
      s[i] = toupper(s[i]);
  }

  return s;
}

#if 0
// do upper-case comparison
int strupcmp(const char *a, const char *b) {
  char *ua, *ub;
  int retval;

  ua = stringtoupper(stringdup(a));
  ub = stringtoupper(stringdup(b));

  retval = strcmp(ua,ub);

  delete [] ub;
  delete [] ua;

  return retval;
}
#endif

// do upper-case comparison, up to n characters
int strupncmp(const char *a, const char *b, int n) {
#if defined(ARCH_AIX3) || defined(ARCH_AIX4) || defined(_MSC_VER)
   while (n-- > 0) {
      if (toupper(*a) != toupper(*b)) {
	 return toupper(*b) - toupper(*a);
      }
      if (*a == 0) return 0;
      a++; b++;
   }
   return 0;
#else
   return strncasecmp(a, b, n);
#endif
}


// break a file name up into path + name, returning both in the specified
//	character pointers.  This creates storage for the new strings
//	by allocating space for them.
void breakup_filename(char *full, char **path, char **name) {
  char *namestrt;
  int pathlen;

  if(full == NULL) {
    *path = *name = NULL;
    return;
  } else if (strlen(full) == 0) {
    *path = new char[1];
    *name = new char[1];
    (*path)[0] = (*name)[0] = '\0';
    return;
  }

  // find start of final file name
  if((namestrt = strrchr(full,'/')) != NULL && strlen(namestrt) > 0) {
    namestrt++;
  } else {
    namestrt = full;
  }

  // make a copy of the name
  *name = stringdup(namestrt);

  // make a copy of the path
  pathlen = strlen(full) - strlen(*name);
  *path = new char[pathlen + 1];
  strncpy(*path,full,pathlen);
  (*path)[pathlen] = '\0';
} 


// break a configuration line up into tokens.  Returns tokenized string
// if the line is a valid one, i.e. the 2nd word is '=' and there is at 
// least one more word after the equal.
char *command_tokenize(char *newcmd, int *argc, char *argv[]) {
  char *cmd, *eqloc;

  // make a new string with a ' = ' instead of '='
  if(!(eqloc = strchr(newcmd,'=')))
    return NULL;
    
  cmd = new char[strlen(newcmd) + 3];
  strncpy(cmd,newcmd,(eqloc - newcmd));
  strcpy(cmd + (eqloc - newcmd)," = ");
  strcat(cmd,eqloc + 1);

  *argc = 0;

  argv[*argc] = strtok(cmd," ,;\t\n");
  if (argv[*argc] == NULL) {
    delete [] cmd;
    return NULL;
  }

  // see if the first token starts with '#'
  if(!strncmp(argv[0],"#",1)) {
    delete [] cmd;
    return NULL;
  }

  (*argc)++;

  // break up the rest of the string
  while ((argv[*argc] = strtok(NULL," ,;\t\n")) != NULL)
    (*argc)++;

  // make sure the 2nd word is "=", and there are 3 words or more
  if(*argc < 3 || strcmp(argv[1],"=")) {
    delete [] cmd;
    return NULL;
  }

  return cmd;
}


// break a configuration line up into tokens.
char *str_tokenize(char *newcmd, int *argc, char *argv[]) {
  char *cmd;

  cmd = stringdup(newcmd);
  *argc = 0;

  // initialize tokenizing calls
  argv[*argc] = strtok(cmd," ,;\t\n");

  // loop through words until end-of-string, or comment character, found
  while(argv[*argc] != NULL) {
    // see if the token starts with '#'
    if(argv[*argc][0] == '#') {
      delete [] cmd;
      return argv[0];
    } else {
      (*argc)++;		// another token in list
    }
    
    // scan for next token
    argv[*argc] = strtok(NULL," ,;\t\n");
  }

  return (*argc > 0 ? argv[0] : (char *) NULL);
}

#if 0
// get the time of day from the system clock, and store it (in seconds)
double time_of_day(void) {
#if defined(_MSC_VER)
  double t;
 
  t = GetTickCount(); 
  t = t / 1000.0;

  return t;
#else
  struct timeval tm;
  struct timezone tz;

  gettimeofday(&tm, &tz);
  return((double)(tm.tv_sec) + (double)(tm.tv_usec)/1000000.0);
#endif
}


int vmd_check_stdin(void) {
#if defined(_MSC_VER)
  if (_kbhit() != 0)
    return TRUE;
  else
    return FALSE;
#else
  fd_set readvec;
  struct timeval timeout;
  int ret, stdin_fd;

  timeout.tv_sec = 0;
  timeout.tv_usec = 0;
  stdin_fd = 0;
  FD_ZERO(&readvec);
  FD_SET(stdin_fd, &readvec);

#if !defined(ARCH_AIX3)
  ret = select(16, &readvec, NULL, NULL, &timeout);
#else
  ret = select(16, (int *)(&readvec), NULL, NULL, &timeout);
#endif
 
  if (ret == -1) {  // got an error
    printf("select() error while attempting to read text input.\n");
    return FALSE;
  } else if (ret == 0) {
    return FALSE;  // select timed out
  }
  return TRUE;
#endif
}


// return the username of the currently logged-on user
char *vmd_username(void) {
#if defined(_MSC_VER)
  char username[1024];
  unsigned long size = 1023;

  if (GetUserName((char *) &username, &size)) {
    return stringdup(username);
  }
  else { 
    return stringdup("Windows User");
  }
#else
#if defined(ARCH_MACOSX) || defined(ARCH_LINUX) || defined(ARCH_LINUXALPHA) || defined(ARCH_LINUXPPC)
  return stringdup(getlogin());
#else
  return stringdup(cuserid(NULL));
#endif 
#endif
}

int vmd_getuid(void) {
#if defined(_MSC_VER)
  return 0;
#else
  return getuid(); 
#endif
}
#endif 

// take three 3-vectors and compute x2 cross x3; with the results
// in x1.  x1 must point to different memory than x2 or x3
// This returns a pointer to x1
float * cross_prod(float *x1, const float *x2, const float *x3)
{
  x1[0] =  x2[1]*x3[2] - x3[1]*x2[2];
  x1[1] = -x2[0]*x3[2] + x3[0]*x2[2];
  x1[2] =  x2[0]*x3[1] - x3[0]*x2[1];
  return x1;
}

// normalize a vector, and return a pointer to it
// Warning:  it changes the value of the vector!!
float * vec_normalize(float *vect) {
  float len = vect[0]*vect[0] + vect[1]*vect[1] + vect[2]*vect[2];
  if (len != 1) {
    len = sqrtf(len);
    vect[0] /= len;
    vect[1] /= len;
    vect[2] /= len;
  }
  return vect;
}


// find and return the norm of a 3-vector
float norm(const float *vect)
{
  return sqrtf(vect[0]*vect[0] + vect[1]*vect[1] + vect[2]*vect[2]);
}

// determine if a triangle is degenerate or not
int tri_degenerate(const float * v0, const float * v1, const float * v2) {
  float s1[3], s2[3], s1_length, s2_length;

  /*
   various rendering packages have amusingly different ideas about what
   constitutes a degenerate triangle.  -1 and 1 work well.  numbers
   below 0.999 and -0.999 show up in OpenGL
   numbers as low as 0.98 have worked in POVRay with certain models while
   numbers as high as 0.999999 have produced massive holes in other
   models
         -matt 11/13/96
  */

  /**************************************************************/
  /*    turn the triangle into 2 normalized vectors.            */
  /*    If the dot product is 1 or -1 then                      */
  /*   the triangle is degenerate                               */
  /**************************************************************/
  s1[0] = v0[0] - v1[0];
  s1[1] = v0[1] - v1[1];
  s1[2] = v0[2] - v1[2];

  s2[0] = v0[0] - v2[0];
  s2[1] = v0[1] - v2[1];
  s2[2] = v0[2] - v2[2];

  s1_length = sqrtf(s1[0]*s1[0] + s1[1]*s1[1] + s1[2]*s1[2]);
  s2_length = sqrtf(s2[0]*s2[0] + s2[1]*s2[1] + s2[2]*s2[2]);

  /**************************************************************/
  /*                   invert to avoid divides:                 */
  /*                         1.0/v1_length * 1.0/v2_length      */
  /**************************************************************/

  s2_length = 1.0f / (s1_length*s2_length);
  s1_length = s2_length * (s1[0]*s2[0] + s1[1]*s2[1] + s1[2]*s2[2]);

  // and add it to the list if it's not degenerate
  if ((s1_length >= 1.0 ) || (s1_length <= -1.0)) 
    return 1;
  else
    return 0;
}


// compute the angle (in degrees 0 to 180 ) between two vectors a & b
float angle(const float *a, const float *b) {
  register float amag = sqrtf(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
  register float bmag = sqrtf(b[0] * b[0] + b[1] * b[1] + b[2] * b[2]);
  register float dotprot = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
  if (amag == 0 || bmag == 0) {
    return 180;
  }
  return (float) (57.2958 * acosf(dotprot / (amag * bmag)));
}

// compute the angle (in degrees -180 to 180) between two vectors a & b
// vector c must be orthogonal to both a and b and gives the
// positive direction for the cross product of a and b. 
// There is no error checking for orthogonality of c to a and b.
float signed_angle(const float *a, const float *b, const float *c) {
  float crossp[3];
  register float amag = sqrtf(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
  register float bmag = sqrtf(b[0] * b[0] + b[1] * b[1] + b[2] * b[2]);
  register float dotprot = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
  if (amag == 0 || bmag == 0) {
    return 180;
  }
  cross_prod(crossp, a, b);
  int sign = (crossp[0]*c[0] + crossp[1]*c[1] + crossp[2]*c[2] < 0)? -1 : 1;

  return (float) (sign * 57.2958 * acosf(dotprot / (amag * bmag)));
}


// compute the distance between points a & b
float distance(const float *a, const float *b) {
  return sqrtf(distance2(a,b));
}

// compute the squared distance between points a & b
float distance2(const float *a, const float *b) {
  float c[3];
  vec_sub(c,a,b);
  return (c[0]*c[0] + c[1]*c[1] + c[2]*c[2]);
}

/// conversion from a string to a boolean
// returns TRUE == 1, FALSE == 0, and unknown == -1
int str2bool(const char *s)
{
  if (!strncasecmp("true", s, 5)) return 1;  // perhaps I went a bit overboard
  if (!strncasecmp("yes", s, 4)) return 1;
  if (!strncasecmp("yep", s, 4)) return 1;
  if (!strncasecmp("si", s, 3)) return 1;
  if (!strncasecmp("oui", s, 4)) return 1;
  if (!strncasecmp("1", s, 2)) return 1;
  if (!strncasecmp("on", s, 3)) return 1;
  if (!strncasecmp("yeah", s, 5)) return 1;
  if (!strncasecmp("ja", s, 3)) return 1;
  if (!strncasecmp("t", s, 2)) return 1;
  
  if (!strncasecmp("false", s, 6)) return 0; 
  if (!strncasecmp("no", s, 3)) return 0;
  if (!strncasecmp("nope", s, 5)) return 0;
  if (!strncasecmp("bo", s, 3)) return 0;
  if (!strncasecmp("non", s, 4)) return 0;
  if (!strncasecmp("0", s, 2)) return 0;
  if (!strncasecmp("off", s, 4)) return 0;
  if (!strncasecmp("nah", s, 4)) return 0;
  if (!strncasecmp("nine", s, 5)) return 0;
  if (!strncasecmp("f", s, 2)) return 0;
  
  return -1;
}

#if 0
int vmd_delete_file(const char * path) {
#if defined(_MSC_VER)
  if (DeleteFile(path) == 0) 
    return -1;
  else 
    return 0;  
#else
  return unlink(path);
#endif
}

void vmd_sleep(int secs) {
#if defined(_MSC_VER)
  Sleep(secs * 1000);
#else 
  sleep(secs);
#endif
}

void vmd_msleep(int msecs) {
#if defined(_MSC_VER)
  Sleep(msecs);
#else 
  struct timeval timeout;
  timeout.tv_sec = 0;
  timeout.tv_usec = 1000 * msecs;

#if !defined(ARCH_AIX3)
  select(0, NULL, NULL, NULL, &timeout);
#else
  select(0, NULL, NULL, NULL, &timeout);
#endif

#endif // _MSC_VER
}

#endif
