/***************************************************************************
 * DESCRIPTION:
 *	strlib contains a number of useful routines for doing file I/O
 * and some basic string manipulation.  These routines are used for 
 * reading in the parameter and .psf files
 *
 ***************************************************************************/


#ifndef STRLIB_H

#define STRLIB_H

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#ifndef SP2
#include <strings.h>
#endif

void	NAMD_truncate(char *);		//  Remove trailing spaces from
					//  a string
int	NAMD_read_line(FILE *, char *); //  Read in a line from a file
int     NAMD_read_line_keepwhite(FILE *, char *); // Read in a line from a file, 
                                                  // don't remove leading whitspaces 
int	NAMD_find_word(const char *, const char *); //  Check for given word in a
					//  string
int	NAMD_blank_string(char *);	//  Check to see if a string
					//  is blank
void	NAMD_find_first_word(char *, char *);
					//  Find the first word in a string
int	NAMD_read_int(FILE *, const char *);  //  Read an integer from a file
void	NAMD_pad(char *, size_t);	//  Pad a string with leading spaces
void	NAMD_remove_comment(char *);	//  Remove comments at the end of
					//  a line demarked by !

//  Add definitions for missing library routines in AIX
#ifdef SP2
int strcasecmp(const char s[], const char t[]);
int strncasecmp(const char s[], const char t[], int n);
#endif

#endif
/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: strlib.h,v $
 *	$Author: saam $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 2004/05/16 08:04:45 $
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: strlib.h,v $
 * Revision 1.4  2004/05/16 08:04:45  saam
 *  Modified Files:
 *  	ComputeBonded.C ComputeNonbonded.C ComputeNonbonded.h
 *  	Energies.C Energies.h HBonds.C Hydrogen.h LoadDCD.h MDEBase.C
 *  	MDEBase.h MDEnergy.C Makefile Mindy.h Molecule.C Molecule.h
 *  	Parameters.h ReadDCD.C ReadDCD.h Selection.C auxil.C auxil.h
 *  	strlib.C strlib.h
 *  ----------------------------------------------------------------------
 *
 * Revision 1.3  2003/07/26 09:57:29  saam
 * added coordinate smoothing
 *
 *  Modified Files:
 *  	Hydrogen.h Lattice.h ReadDCD.C ReadDCD.h Timestep.C Timestep.h
 *  	strlib.h utilities.C utilities.h
 *  ----------------------------------------------------------------------
 *
 * Revision 1.1.1.1  2003/01/02 00:22:31  saam
 * MDE with hbondpsf
 *
 * Revision 2.01  2002/03/20 06:38:57  saam
 * try to remove Integrator again...
 *
 * Revision 2.0  2002/03/19 05:41:32  saam
 * removed integration from MDForce.C
 *
 * Revision 1.15  2002/03/19 03:44:29  saam
 * last 1.x version
 * with interaction
 *
 * Revision 1.14  2002/03/19 01:52:32  saam
 * selections and interaction energies work
 *
 * Revision 1.1.1.1  2001/08/30 23:32:41  saam
 * mdforce
 *
 * Revision 1.1.1.1  2001/08/30 23:03:52  saam
 * mdforce
 *
 * Revision 1.1  1999/08/06 04:02:04  justin
 * Initial revision
 *
 * Revision 1.1  1999/08/06 03:59:32  justin
 * Initial revision
 *
 * Revision 1.1004  1999/07/08 21:27:10  jim
 * Eliminated compiler warnings.
 *
 * Revision 1.1003  1998/10/24 19:58:10  jim
 * Eliminated warnings generated by g++ -Wall.
 *
 * Revision 1.1002  1997/07/09 21:26:46  milind
 * Ported NAMD2 to SP3. The SP specific code is within #ifdef SP2
 * and #endif's.
 *
 * Revision 1.1001  1997/03/19 11:55:05  ari
 * Add Broadcast mechanism.
 * Fixed RCS Log entries on files that did not have Log entries.
 * Added some register variables to Molecule and ComputeNonbondedExcl.C
 *
 * Revision 1.1000  1997/02/06 15:59:39  ari
 * Resetting CVS to merge branches back into the main trunk.
 * We will stick to main trunk development as suggested by CVS manual.
 * We will set up tags to track fixed points of development/release
 * as suggested by CVS manual - all praise the CVS manual.
 *
 * Revision 1.778  1997/01/28 00:31:40  ari
 * internal release uplevel to 1.778
 *
 * Revision 1.777.2.1  1997/01/27 22:45:47  ari
 * Basic Atom Migration Code added.
 * Added correct magic first line to .h files for xemacs to go to C++ mode.
 * Compiles and runs without migration turned on.
 *
 * Revision 1.777  1997/01/17 19:37:16  ari
 * Internal CVS leveling release.  Start development code work
 * at 1.777.1.1.
 *
 * Revision 1.1  1996/08/06 20:38:38  ari
 * Initial revision
 *
 * Revision 1.5  1995/04/10 11:30:38  nelson
 * Added strcasecmp and strncasecmp for AIX
 *
 * Revision 1.4  95/03/08  14:46:25  14:46:25  nelson (Mark T. Nelson)
 * Added copyright
 * 
 * Revision 1.3  95/01/26  14:14:27  14:14:27  nelson (Mark T. Nelson)
 * Added function NAMD_remove_comment for charmm22 parameters
 * 
 * Revision 1.2  94/09/30  09:09:47  09:09:47  nelson (Mark T. Nelson)
 * added NAMD_pad function
 * 
 * Revision 1.1  94/06/22  15:05:57  15:05:57  nelson (Mark T. Nelson)
 * Initial revision
 * 
 ***************************************************************************/
