/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2001 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Timestep.h,v $
 *	$Author: saam $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 2003/07/26 09:57:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The Timestep class, which stores coordinates, energies, etc. for a
 * single timestep.
 *
 * Note: As more data is stored for each step, it should go in here.  For
 * example, H-Bonds could be calculated each step.
 ***************************************************************************/
#ifndef TIMESTEP_H
#define TIMESTEP_H

// coordinates to store for each atom
#define ATOMCOORDS	3


// These are still from VMD
// #include "Atom.h"
// #include "ResizeArray.h"

// I added this from Mindy
# include "Vector.h"

//
// useful defines
//

// energy terms and temperature stored for each timestep

// TSENERGIES must be the last element.  It indicates the number
// energies.  (TSE_TOTAL is the total energy).  If you add fields here
// you should also add the lines in MolInfo.C so you can get access to
// the fields from Tcl.
enum { TSE_BOND, TSE_ANGLE, TSE_DIHE, TSE_IMPR, TSE_VDW, TSE_COUL,
       TSE_HBOND, TSE_KE, TSE_PE, TSE_TEMP, TSE_TOTAL, TSE_VOLUME,
       TSE_PRESSURE, TSE_EFIELD, TSE_UREY_BRADLEY, TSE_RESTRAINT,
       TSENERGIES};

class Timestep {

// while this is a class, almost all the members are public
public:
  // number of atoms this timestep is for
  int num;
  
  // coordinates of all the atoms, as (x,y,z), (x,y,z), ...
  float *pos;

  // forces for all the atoms. These are written only by MoleculeIMD
  //ResizeArray<float> force;
  
  // energy for this step; by default, all 0
  float energy[TSENERGIES];
  
  // center of volume position
  float COV[ATOMCOORDS];

  // scale factor to get the coordinate set to fix in (-1 ... 1) box
  float scale_factor;

  // time required to compute this timestep .... if unknown, should be 0
  float dt;

  // has this timestep been initialized?
  int Initialized;

  // size and shape of unit cell 
  float a_length, b_length, c_length, alpha, beta, gamma;
 
public:
  // constructor: # atoms, time used to compute this timestep,
  // and 'data' items; if latter is null, space is allocated.
  Timestep(int n, float DT);

  // copy constructor 
  Timestep(const Timestep& ts);
  
  // destructor
  ~Timestep(void);
  
  // calculate the max/min values for all the quantities, and anything else
  // required based on atom coordinates, etc.  Used for scaling
  // and translating purposes.
  void init(void);

  // set the coords to 0, then re-init
  void zero_values(void);

  //  Get all the atom positions into a list of Vectors
  void get_all_positions(Vector *v);

};

#endif

