/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2001 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Timestep.C,v $
 *	$Author: saam $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 2003/09/02 14:14:50 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The Timestep class, which stores coordinates, energies, etc. for a
 * single timestep.
 *
 * Note: As more data is stored for each step, it should go in here.  For
 * example, H-Bonds could be calculated each step.
 ***************************************************************************/

#include <math.h>
#include "Timestep.h"
//#include "Inform.h"
#include <string.h> // void *memset(void *s, int c, size_t n);
//#include "Atom.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

///////////////////////////  constructor  

Timestep::Timestep(int n, float DT) {
  for(int i=0; i < TSENERGIES; energy[i++] = 0.0);
  num = n;
  dt = DT;
  pos = new float[ATOMCOORDS * num];
  scale_factor = 1.0;
  a_length = b_length = c_length = 1;
  alpha = beta = gamma = 90;
  Initialized = FALSE;
}


// copy constructor

Timestep::Timestep(const Timestep& ts) {
  num = ts.num;
  pos = new float[ATOMCOORDS * num];
  memcpy(pos, ts.pos, ATOMCOORDS * num * sizeof(float));
  memcpy(energy, ts.energy, sizeof(ts.energy));
  memcpy(COV, ts.COV, sizeof(COV));
  scale_factor = ts.scale_factor;
  dt = ts.dt;
  Initialized = ts.Initialized;

}

///////////////////////////  destructor  

Timestep::~Timestep(void) {
  if (pos)
    delete [] pos;
}

//////////////////////////  public routines  

// calculate the max/min values for all the quantities, and anything else
// required based on atom coordinates, etc.  Used for scaling
// and translating purposes.
void Timestep::init(void) {
  int i, j;
  float *mpos = pos;

  // minimum and maximum values for position 
  float minpos[ATOMCOORDS];
  float maxpos[ATOMCOORDS];

  // only do this if there are atoms
  if(!num)
    return;		

  // inialize min/max positions
  for(i=0; i < ATOMCOORDS; i++) {
    minpos[i] = maxpos[i] = pos[i];		// take values for first atom
    COV[i] = 0.0;
  }  

  // calc ranges for all atoms
  for(i=0; i < num; i++) {
    for(j=0; j < ATOMCOORDS; j++) {
      COV[j] += mpos[j];
      if(mpos[j] < minpos[j])
        minpos[j] = mpos[j];
      else if(mpos[j] > maxpos[j])
        maxpos[j] = mpos[j];
    }
    mpos += ATOMCOORDS;
  }
  
  // calculate center-of-volume and scale factor
  scale_factor = maxpos[0] - minpos[0];
  for(i=0; i < ATOMCOORDS; i++) {
    COV[i] /= (float)num;
    if((maxpos[i] - minpos[i]) > scale_factor)
      scale_factor = maxpos[i] - minpos[i];
  }
  scale_factor = 1.5f / scale_factor;

  Initialized = TRUE;
}


// reset coords and related items to 0
void Timestep::zero_values(void) {
  if (num <= 0) 
    return;
    
  memset(pos,0,3*num*sizeof(float));
   
  for(int i=0; i < TSENERGIES; energy[i++] = 0.0);
  scale_factor = 1.0;
  init();
}

#include "auxil.h"
// This was added to comply Mindy-style positions:
// Get all the atom positions into a list of Vectors
void Timestep::get_all_positions(Vector *v)
{
  int i,j;
  for (i=0, j=0; i<num; i++, j+=3)
    {

      v[i].x = (double) pos[j];
      v[i].y = (double) pos[j+1];
      v[i].z = (double) pos[j+2];
    }
}
