// Selection.h
// Read files with atom indices as selections
#ifndef SELECTION_H
#define SELECTION_H

class Selection {
public:
    int natoms;
    int ntotal;
    char *seltext;
    int  *atomsel;
    int  *byAtom;

    Selection();
    ~Selection();
    void read(const char *selfile, int ntotal);
    void select_all(int ntotal);
    void invert_list();
    void intersect_with_fixed(Selection *fixedatoms);
    void checkprint() const;
    void text() const;
 private:
    void make_byatom_list();
};

#endif
