/**************************************************************/
/**************************************************************/
/***                                                        ***/
/***   Ringbuf.C                                            ***/
/***                                                        ***/
/***   A ringbuffer class that manages pointers to          ***/
/***   the actual objects. The object number and size       ***/
/***   must be specified.                                   ***/
/***                                                        ***/
/***   Fill the buffer with set_next()                      ***/
/***   Navigation with get_next()                           ***/
/***                                                        ***/
/***                                                        ***/
/**************************************************************/
/**************************************************************/

#include <iostream.h>
#include <string.h>
#include "Ringbuf.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

Ringbuf::Ringbuf() {
  buf = NULL; 
  ptr = 0;
  len = 0;
  element_size=0;
}


// Important: elem_size must be correct!
// Determine with sizeof().
Ringbuf::Ringbuf(int n, size_t elem_size) {
  buf = new char*[n];
  for(int i=0; i<n; i++) {
    char* elem = new char[elem_size];
    memset((void*) elem, 0, elem_size);
    buf[i] = elem;
  }
  ptr = 0;
  len = n;
  element_size=elem_size;
}

Ringbuf::~Ringbuf() {
  for(int i=0; i<len; i++) {
    delete [] buf[i];
  }
  delete [] buf;
  buf = NULL;
}

void Ringbuf::init(int n, size_t elem_size) {
  buf = new char*[n];
  for(int i=0; i<n; i++) {
    char* elem = new char[elem_size];
    memset((void*) elem, 0, elem_size);
    buf[i] = elem;
  }
  ptr = 0; 
  len = n;
  element_size=elem_size;
}

int Ringbuf::length() {
  return len;
}

void Ringbuf::get_next(void* elem) {
  memcpy(elem, buf[ptr], element_size);
  if (ptr==len-1) ptr=0;
  else ptr++;
  if (ptr>=len) { 
    cerr<<"Ringbuf: Ptr off boundary!"<<endl;
    exit(0);
  }
}

void Ringbuf::set_next(const void* elem) {
  memcpy(buf[ptr], elem, element_size);
  if (ptr==len-1) ptr=0;
  else ptr++;
  if (ptr>=len) { 
    cerr<<"Ringbuf: Ptr off boundary!"<<endl;
    exit(0);
  }
}

void Ringbuf::shift(int n) {
  int rest = len-1-ptr;
  if (rest>=n) ptr += n;
  else ptr = (n-rest)%len;
}
