#ifndef READDONACC_H
#define READDONACC_H

// ReadDonAcc.h

struct Donor;
struct Acceptor;
class Molecule;
class DonAcc;
class Residue;
class HBonds;

class Residue {
  friend class DonAcc;  // access to private data
private:
  char resname[11];
  Donor *donors;
  Acceptor *acceptors;
  int ndon;
  int nacc;
public:
  Residue();
  ~Residue();
  Residue& operator= (const Residue& res);
  void add_donor(const char* don, const char* hyd);
  void add_acceptor(const char* acc, const char* ant);
  //friend DonAcc* Molecule::read_donors_and_acceptors(const char* fn);
};


class DonAcc {
private:
  Residue *resi;
  int nres;
public:
  DonAcc();
  ~DonAcc();
  void add_residue(const char* name);
  int num_res() { return nres; };
  int is_donor(const char* resname, const char* atomname) const;
  int is_acceptor(const char* resname, const char* atomname) const;
  int is_donor_H(const char* resname, const char* donname, const char* hydname) const;
  int is_acceptor_A(const char* resname, const char* accname, const char* antename) const;
  int get_resid(const char* name);
  void add_donor(int res, const char* don, const char* hyd) {
    resi[res].add_donor(don, hyd) ;
  };
  void add_acceptor(int res, const char* acc, const char* ant) {
    resi[res].add_acceptor(acc, ant) ;
  };
};

DonAcc* read_donors_and_acceptors(const char* fn);

// Adapted from pdb_file_extract.h (psfgen)
int pdb_file_extract_residues(FILE *file, DonAcc *donacc, HBonds *hbonds);

// The following is from pdb_file.h (psfgen)
#define PDB_RECORD_LENGTH       80

/*      record type defines     */
enum {PDB_REMARK, PDB_ATOM, PDB_UNKNOWN, PDB_END, PDB_EOF, PDB_CRYST1};

/* read the next record from the specified pdb file, and put the string found
   in the given string pointer (the caller must provide adequate (81 chars)
   buffer space); return the type of record found
*/
int read_pdb_record(FILE *f, char *retStr);

/* Break a pdb atom record into it's fields.  The user must provide the
   necessary space to store the atom name, residue name, and segment name.
   Character strings will be null-terminated.  Returns the atom serial number. */
int get_pdb_fields(char *record, char *name, char *resname, char *chain,
                   char *segname, char *resid, char *insertion, float *x,
                   float *y, float *z, float *occup, float *beta);


#endif
