#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "ReadDonAcc.h"
#include "HBonds.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

struct Donor {
  char don[11];
  char hyd[11];
};

struct Acceptor {
  char acc[11];
  char ant[11];
};


DonAcc::DonAcc() {
  nres = 0;
  resi = NULL;
}

DonAcc::~DonAcc() {
  if (resi) delete [] resi;
  resi = NULL;
}

int DonAcc::is_donor(const char* resname, const char* atomname) const {
  for (int i=0; i<nres; i++) {
    if (!strcmp(resi[i].resname, resname)) {
      for (int j=0; j<resi[i].ndon; j++) {
	if (!strcmp(resi[i].donors[j].don, atomname)) {
	  return 1;
	}
      }
    }
  }
  return 0;
}


int DonAcc::is_acceptor(const char* resname, const char* atomname) const {
  for (int i=0; i<nres; i++) {

    if (!strcmp(resi[i].resname, resname)) {
      for (int j=0; j<resi[i].nacc; j++) {
	if (!strcmp(resi[i].acceptors[j].acc, atomname)) {
	  return 1;
	}
      }
    }
  }
  return 0;
}


int DonAcc::is_donor_H(const char* resname, const char* donname, const char* hydname) const {
  for (int i=0; i<nres; i++) {
    if (!strcmp(resi[i].resname, resname)) {
      for (int j=0; j<resi[i].ndon; j++) {
	if (!strcmp(resi[i].donors[j].don, donname)) {
	  if (!strcmp(resi[i].donors[j].hyd, hydname)) return 1;
	}
      }
    }
  }
  return 0;
}

int DonAcc::is_acceptor_A(const char* resname, const char* accname, const char* antename) const {
  for (int i=0; i<nres; i++) {
    if (!strcmp(resi[i].resname, resname)) {
      int none=0;
      for (int j=0; j<resi[i].nacc; j++) {
	if (!strcmp(resi[i].acceptors[j].acc, accname)) {
	  if (!strcmp(resi[i].acceptors[j].ant, antename)) return 1;
	  if (!strcmp(resi[i].acceptors[j].ant, "NONE"))  none=1;
	}
      }
      if (none) return -1;
    }
  }
  return 0;
}

int DonAcc::get_resid(const char* name) {
    for (int i=0; i<nres-1; i++) {
	if (!strcmp(resi[i].resname, name)) return i;
    }
    return -1;
}

void DonAcc::add_residue(const char* name) {
  Residue* tmp = new Residue[++nres];
  for (int i=0; i<nres-1; i++) tmp[i] = resi[i]; // copy
  
  if (resi) delete [] resi;
  resi = tmp;
  strcpy(resi[nres-1].resname, name);
}


Residue::Residue() {
  ndon=0;
  nacc=0;
  donors = NULL;
  acceptors = NULL;
}
 
Residue& Residue::operator=(const Residue& res) {
  //caution with self assignment res=res
  if (this!=&res) {
    int i; 
    for (i=0; i<11; i++) resname[i] = res.resname[i];
    delete [] donors;
    delete [] acceptors;
    ndon = res.ndon;
    nacc = res.nacc;
    donors    = new Donor[res.ndon];
    acceptors = new Acceptor[res.nacc];
    for (i=0; i<res.ndon; i++) donors[i] = res.donors[i];
    for (i=0; i<res.nacc; i++) acceptors[i] = res.acceptors[i];
  }
  return *this;
}


Residue::~Residue() {
  if (donors) delete [] donors;
  donors = NULL;
  if (acceptors) delete [] acceptors;
  acceptors = NULL;
}

void Residue::add_donor(const char* don, const char* hyd) {
  Donor* tmp = new Donor[++ndon];
  for (int i=0; i<ndon-1; i++) tmp[i] = donors[i];

  if (donors) delete [] donors;
  donors = tmp;
  strcpy(donors[ndon-1].hyd, hyd);
  strcpy(donors[ndon-1].don, don);
}

void Residue::add_acceptor(const char* acc, const char* ant) {
  Acceptor* tmp = new Acceptor[++nacc];
  for (int i=0; i<nacc-1; i++) tmp[i] = acceptors[i];

  if (acceptors) delete [] acceptors;
  acceptors = tmp;
  strcpy(acceptors[nacc-1].acc, acc);
  strcpy(acceptors[nacc-1].ant, ant);
}


DonAcc* read_donors_and_acceptors(const char* fn) {
  FILE* fd = fopen(fn, "r");
  if (fd==NULL) {
      fprintf(stderr, "ERROR opening topfile: %s\n", fn);
      exit(1);
  }

  char tmp[1000];
  char keyword[100];
  char resname[11];

  // Don't forget to delete !!!
  DonAcc *da = new DonAcc;
  while (!feof(fd)) {
    fgets(tmp, 1000, fd);        /* read the line */
    strcpy(keyword, "\0");       // Reset keyword
    int key = sscanf (tmp, "%s", keyword); /* get the first token */
    if (key>0 && (!strcmp(keyword, "RESI")|| !strcmp(keyword, "PRES"))) {
      sscanf(tmp, "%s %s", keyword, resname);
      da->add_residue(resname);
      //      cout << da->num_res()<<endl;
      // printf("\n%d %s %s\n", da->num_res(), keyword, resname);
    }

    if (!strcmp(keyword, "DONOR") || !strcmp(keyword, "DON")) {
      char don[11], hyd[11];
      sscanf(tmp, "%s %s %s", keyword, hyd, don);
      printf("%s %s %s\n", keyword, don, hyd); 
      da->add_donor(da->num_res()-1, don, hyd);
    }
    if (!strcmp(keyword, "ACCEPTOR") || !strcmp(keyword, "ACC")) {
      char acc[11], ant[11];
      strcpy(ant,"NONE");
      sscanf(tmp, "%s %s %s", keyword, acc, ant);
      //printf("%s %s %s\n", keyword, acc, ant); 
      da->add_acceptor(da->num_res()-1, acc, ant);
    }
  }
  fclose(fd);
  return da;
}

// Adapted from pdb_file_extract.h (psfgen)
int pdb_file_extract_residues(FILE *file, DonAcc *donacc, HBonds *hbonds) {

  char record[PDB_RECORD_LENGTH+2];
  int indx, atomindex;
  float x,y,z,o,b;
  char name[8], resname[8], chain[8];
  char segname[8], resid[8], insertion[8];
  char oldresid[8];
  //const char *realres;
  int rcount;
  //HBonds hbonds;

  rcount = 0;
  oldresid[0] = '\0';

  do {
      if((indx = read_pdb_record(file, record)) == PDB_ATOM) {
	  atomindex = get_pdb_fields(record, name, resname, chain,
				     segname, resid, insertion, &x, &y, &z, &o, &b);
	  if ( strcmp(oldresid,resid) ) {
	      strcpy(oldresid,resid);
	      ++rcount;
	      //realres = extract_alias_residue_check(h,resname);
	  }
	  if (donacc->is_acceptor(resname, name)) {
	      printf("%i %s %s %s", atomindex, name, resname, resid);
	      //int ante = check_antecedent(atomindex);
	      //printf("  ante: %i\n", ante);
	  }
      }
  } while (indx != PDB_END && indx != PDB_EOF);
  
  printf("Extracted %d residues from pdb file.\n",rcount);
  return 0;
}

// The following is from pdb_file.h (psfgen)

/* read the next record from the specified pdb file, and put the string found
   in the given string pointer (the caller must provide adequate (81 chars)
   buffer space); return the type of record found
*/
int read_pdb_record(FILE *f, char *retStr) {

  char inbuf[PDB_RECORD_LENGTH+2];
  int recType = PDB_UNKNOWN;

  /*    read the next line      */
  if(inbuf != fgets(inbuf, PDB_RECORD_LENGTH+1, f)) {
    strcpy(retStr,"");
    recType = PDB_EOF;
  } else {
    /*  remove the newline character, if there is one */
    if(inbuf[strlen(inbuf)-1] == '\n')
      inbuf[strlen(inbuf)-1] = '\0';

    /* what was it? */
    if (!strncmp(inbuf, "REMARK", 6)) {
      recType = PDB_REMARK;

    } else if (!strncmp(inbuf, "CRYST1", 6)) {
      recType = PDB_CRYST1;

    } else if (!strncmp(inbuf, "ATOM  ", 6) ||
               !strncmp(inbuf, "HETATM", 6)) {
      recType = PDB_ATOM;

      /* the only two END records are "END   " and "ENDMDL" */
    } else if (!strcmp(inbuf, "END") ||       /* If not space " " filled */
               !strncmp(inbuf, "END ", 4) ||  /* Allows other stuff */
               !strncmp(inbuf, "ENDMDL", 6)) { /* NMR records */
      recType = PDB_END;

    } else {
      recType = PDB_UNKNOWN;
    }

    if(recType == PDB_REMARK || recType == PDB_ATOM ||
       recType == PDB_CRYST1) {
      strcpy(retStr,inbuf);
    } else {
      strcpy(retStr,"");
    }
  }

  /* read the '\r', if there was one */
  {
    int ch = fgetc(f);
    if (ch != '\r') {
      ungetc(ch, f);
    }
  }

  return recType;
}

/* Break a pdb ATOM record into its fields.  The user must provide the
   necessary space to store the atom name, residue name, and segment name.
   Character strings will be null-terminated.  Returns the atom serial number.
*/
int get_pdb_fields(char *record, char *name, char *resname, char *chain,
                   char *segname, char *resid, char *insertion, float *x,
                   float *y, float *z, float *occup, float *beta) {
  int i,len, num, base;

  num=0;

  /* get serial number */
  if (record[6] >= 'A' && record[6] <= 'Z') {
    /* If there are too many atoms, XPLOR uses 99998, 99999, A0000, A0001, */
    base = ((int)(record[6] - 'A') + 10) * 100000;
    sscanf(record + 6, "%d", &num);
    num += base;
  } else {
    sscanf(record + 6,"%d",&num);
  }

  /* get atom name */
  strncpy(name,record + 12, 4);
  name[4] = '\0';
  while((len = strlen(name)) > 0 && name[len-1] == ' ')
    name[len-1] = '\0';
  while(len > 0 && name[0] == ' ') {
    for(i=0; i < len; i++)  name[i] = name[i+1];
    len--;
  }

  /* get residue name */
  strncpy(resname,record + 17, 4);
  resname[4] = '\0';
  while((len = strlen(resname)) > 0 && resname[len-1] == ' ')
    resname[len-1] = '\0';
  while(len > 0 && resname[0] == ' ') {
    for(i=0; i < len; i++)  resname[i] = resname[i+1];
    len--;
  }

  chain[0] = record[21];
  chain[1] = 0;

  /* get residue id number */
  strncpy(resid,record + 22, 4);
  resid[4] = '\0';
  while((len = strlen(resid)) > 0 && resid[len-1] == ' ')
    resid[len-1] = '\0';
  while(len > 0 && resid[0] == ' ') {
    for(i=0; i < len; i++)  resid[i] = resid[i+1];
    len--;
  }

  insertion[0] = record[26];
  insertion[1] = 0;

  /* get x, y, and z coordinates */
  //get_pdb_coordinates(record, x, y, z, occup, beta);

  /* get segment name   */
  if(strlen(record) >= 73) {
    strncpy(segname, record + 72, 4);
    segname[4] = '\0';
    while((len = strlen(segname)) > 0 && segname[len-1] == ' ')
      segname[len-1] = '\0';
    while(len > 0 && segname[0] == ' ') {
      for(i=0; i < len; i++)  segname[i] = segname[i+1];
      len--;
    }
  } else {
    strcpy(segname,"");
  }

  return num;
}



