//Loaddcd.h
#ifndef LOADDCD_H
#define LOADDCD_H

#include <string.h>
#include <stdio.h>
#include "ReadDCD.h"
#include "Vector.h"
#include "Timestep.h"

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#ifndef NULL
#define NULL 0
#endif
/*

// error flag values; should be > 0
#define DCD_ERR_NOTOPEN		1
#define DCD_ERR_EARLYEOF	2
#define DCD_ERR_NOATOMS		3
#define DCD_ERR_EXTRA		4
#define DCD_ERR_A_NOT_EQ	5
#define DCD_ERR_NOFILE		6
#define DCD_ERR_BADFORMAT	7
#define DCD_ERR_FILEEXISTS	8


char* coor_dcd_errors[] = {
  (char *) "DCD file okay",
  (char *) "DCD file not open",
  (char *) "Early end to DCD file",
  (char *) "No atoms found in DCD file",
  (char *) "Extra something or other",
  (char *) "Number of atoms in DCD file not equal to number in molecule",
  (char *) "DCD file does not exist",
  (char *) "Improper format for DCD file",
  (char *) "File already exists"
};
*/

class DCD
{
public:
  // file type enum
  enum DCDTYPE { ASCII, BINARY };

  //  from CoorFile.h:
  // is the file opened properly and ready for I/O?
   int Initialized;

private:
  // type of file, ascii or binary
  DCDTYPE fileType;
  
  // file number, if file is opened as binary
  FILE* fileptr;
  
  // timestep size (in ps)
  double timeStep;
  
  // starting frame, and frameskip (# timesteps between each frame write)
  int frameStart, frameSkip;
  
  // temp read buffer
  float *X, *Y, *Z;
  
  // free-atom list data
  int namnf, *freeatoms;

  // endianism - do we need to revert?
  int reverseEndian;

  // CHARMm flags (see comments in read_dcdheader() of ReadDCD.C)
  int charmmFlags;

  //  from CoorFile.h:
  // -------------------
  
  // atoms in this coor file
  int nAtoms;
  
  // number of frames this file contains, or can contain
  int nFrames;

  // frames processed so far (if 0, none read/written yet)
  int currFrames;

public:
  DCD();
  ~DCD(void);
  int       openread(const char* filename);
  int       openwrite(char* filename, int nAtoms, int nFrames, int frameStart,
			     int frameSkip, int timeStep);
  Timestep* read(void);
  Timestep* read(int frame);       
  int       write(Timestep& pos);
  int       write(FILE * fd, int N, float *X, float *Y, float *Z);
  void      closewrite();
  int       opened(void) { return Initialized; };
  int       file_type(void) { return fileType; }
  int       num_atoms() { return nAtoms; };
  FILE*     get_fd()    { return fileptr; };
  int       num_fixed() { return namnf; };
  int       num_free()  { return nAtoms-namnf; };
  int*      free_atoms() { return freeatoms; };
  int       num_frames() { return nFrames; };
  void      set_num_frames(int n) { nFrames=n; };
  int       count_frames();
  void      rewind() { (void)fseek(fileptr, 0L, SEEK_SET); }
  int       curr_frame() { return currFrames; };
  int       delta_t()  { return frameSkip; };
  int       start_t()  { return frameStart; };
  double    timestep()  { return timeStep; };
  int       is_charmm() { return (charmmFlags & DCD_IS_CHARMM); };
  int       has_4dims() { return (charmmFlags & DCD_HAS_4DIMS); };
  int       has_extra_block() { return (charmmFlags & DCD_HAS_EXTRA_BLOCK); };
  int       is_reverse() { return reverseEndian; };
  const char*  get_format() const { 
    if (charmmFlags & DCD_IS_CHARMM) { return "CHARMM"; } 
    else return "XPLOR"; 
  }
};

#endif
