#ifndef DATABLE_H
#define DATABLE_H

class Parameters;
class Molecule;

struct DATableEntry
{
  double E;
  double R;
};

class DATable
{
public:

  DATable(const Parameters *, const Molecule *);
  ~DATable();

  const DATableEntry *table_val(int i, int j) const {
    return table + i * table_dim2 + j;
  } 
  int get_size() const { return table_sz; }
  void print();

private:

  DATableEntry *table;
  int table_sz;
  int table_dim1;
  int table_dim2;
};

#endif

