#include <math.h>
#include <iostream.h>

#include "DATable.h"
#include "Parameters.h"
#include "Molecule.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

// We generate a numDonortypes-by-numAcceptortypes table with
DATable::DATable(const Parameters *params, const Molecule *mol)
{
    //  table_dim1 = mol->numHDonors;
  table_dim1 = params->get_num_donor_types();
  //table_dim2 = mol->numHAcceptors;
  table_dim2 = params->get_num_accep_types();
  cerr << "numdonortypes=" << params->get_num_donor_types() << endl;
  table_sz = table_dim1 * table_dim2;

  table = new DATableEntry[table_sz];

  for (int i=0; i < table_dim1; i++)
    for (int j=0; j < table_dim2; j++)
    {
      DATableEntry *curij = &(table[i*table_dim2+j]);
      double E, R;
      if (params->get_hbond_pair_params(i, j, &E, &R))
	{
	  curij->E = E;
	  curij->R = R;
	}
      else { 
	curij->E = 0.0;
	curij->R = 0.0;
	cerr << "WARNING: NO HBOND PARAM FOUND FOR " << i << "---" << j << "!\n"
	     << "Using 0 instead!\n";
      }
    }
}

DATable::~DATable()
{
  delete [] table;
}

void DATable::print() {
  for (int i=0; i < table_dim1; i++)
    for (int j=0; j < table_dim2; j++)
      {
	const DATableEntry *curij ;
	  curij = this->table_val(i, j); //&(table[i*table_dim2+j]);
	cout << curij->E << "  " << curij->R << endl;
      }

}
