#ifndef COMPUTE_BONDED_H__
#define COMPUTE_BONDED_H__

class Molecule;
class Parameters;
class Vector;
struct BondElem;
struct AngleElem;
struct DihedralElem;
struct ImproperElem;

class ComputeBonded {
public:
  // constructor creates the lists of bonds, angles, etc.
  ComputeBonded(const Molecule *, const Parameters *, int sel_natoms, int *selectionByAtom, int eflag, int selfonly, int have_fixed);
  ~ComputeBonded();

  // compute the energy, given the set of coordinates
  void compute(const Vector *coords, Vector *f, double *eB, double *eA, \
	       double *eD, double *eI, double& Ebond, double& Eangle,   \
               double &Edihedral, double &Eimproper, Vector &Fbond, 
	       Vector &Fangl, Vector &Fdihe, Vector &Fimpr) const;

  double compute_bonds(const Vector*, Vector*, double*, Vector&) const;
  double compute_angles(const Vector*, Vector *, double*, Vector&) const;
  double compute_dihedrals(const Vector*, Vector*, double*, Vector&) const;
  double compute_impropers(const Vector*, Vector*, double*, Vector&) const;

private:
  int self;
  int request;
  int fixed;
  int natoms;
  int nbonds;
  int nangles;
  int ndihedrals;
  int nimpropers;
  int *selByAtom;

  BondElem *bonds;
  AngleElem *angles; 
  DihedralElem *dihedrals;
  ImproperElem *impropers;
   
  void build_bondlist(const Molecule *, const Parameters *, int sel_natoms);
  void build_anglelist(const Molecule *, const Parameters *, int sel_natoms);
  void build_dihedrallist(const Molecule *, const Parameters *, int sel_natoms);
  void build_improperlist(const Molecule *, const Parameters *, int sel_natoms);
};

#endif
 
