/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995-2001 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: utilities.h,v $
 *	$Author: saam $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 2003/07/26 09:57:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * General utility routines and definitions.
 *
 ***************************************************************************/
#ifndef UTILITIES_H
#define UTILITIES_H

#include <string.h>

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef ABS
#define ABS(A) ((A)>0?(A):-(A))
#endif

#ifndef PI
#define PI      3.141592653589793
#endif
#ifndef TWOPI
#define TWOPI   (2.0 * PI)
#endif


// given an argc, argv pair, take all the arguments from the Nth one on
// and combine them into a single string with spaces separating words.  This
// allocates space for the string, which must be freed by the user.
extern char *combine_arguments(int, char **, int);


// make a copy of a string using c++ new routine for memory alloc
extern char *stringdup(const char *);


// convert the given string to upper case
extern char *stringtoupper(char *);


// do case-insensitive string comparisons
extern int strupcmp(const char *, const char *);
extern int strupncmp(const char *, const char *, int);


//  break a file name up into path + name, returning both in the specified
//      character pointers.  This creates storage for the new strings
//      by allocating space for them.
extern void breakup_filename(char *, char **, char **);


// take a string and break it up into tokens, of form <keyword> = <value>
extern char *command_tokenize(char *, int *, char **);


// tokenize a given string; return char ptr if ok, NULL if error
extern char *str_tokenize(char *, int *, char **);

// get the time of day from the system clock, and return it (in seconds)
//	(This is supposedly accurate to within about 1 millisecond
extern double time_of_day(void);

// check for input on stdin
extern int vmd_check_stdin(void);

// return the username of the currently logged-on user
extern char * vmd_username(void);
// return the uid of the currently logged-on user
extern int vmd_getuid(void);

// compute the cross product, assumes that x1 memory is _different_ 
// than both x2 and x3, and returns the pointer to x1
extern float * cross_prod(float *x1, const float *x2, const float *x3);

// compute the inner dot product
inline float dot_prod(const float *v1, const float *v2)
{
 return v1[0]* v2[0] + v1[1]* v2[1] + v1[2] * v2[2];
}

// copy the first 3 elements from v2 to v1
inline void vec_copy(float *v1, const float *v2) {
  v1[0] = v2[0];
  v1[1] = v2[1];
  v1[2] = v2[2];
}

// normalizes the 3-vector to length one and returns the pointer
// note that this changes the vector
extern float * vec_normalize(float *);

// subtract 3rd vector from 2nd and put into 1st
// in other words, a = b - c
inline void vec_sub(float *a, const float *b, const float *c) {
  a[0]=b[0]-c[0];
  a[1]=b[1]-c[1];
  a[2]=b[2]-c[2];
}

// add 2nd and 3rd elements, put into 1st
inline void vec_add(float *a, const float *b, const float *c) {
  a[0]=b[0]+c[0];
  a[1]=b[1]+c[1];
  a[2]=b[2]+c[2];
}

// a = b*c
inline void vec_scale(float *a, float b, const float *c) {
  a[0] = b*c[0];
  a[1] = b*c[1];
  a[2] = b*c[2];
}

// compute the midpoint a between two vectors b & c (a = (b + c)/2)
inline void midpoint(float *a, const float *b, const float *c) {
  a[0] = 0.5f * (b[0]+c[0]);
  a[1] = 0.5f * (b[1]+c[1]);
  a[2] = 0.5f * (b[2]+c[2]);
}

// determine if a triangle is degenerate or not
extern int tri_degenerate(const float *, const float *, const float *);

// compute the angle between two vectors a & b (0 to 180 deg)
extern float angle(const float *, const float *);

// compute the angle between two vectors a & b (-180 to 180 deg)
extern float signed_angle(const float *, const float *, const float *);

// compute the distance between two points a & b
extern float distance(const float *, const float *);

// compute the squared distance between two points a & b
extern float distance2(const float *, const float *);

// find and return the norm of a 3-vector
extern float norm(const float *);

/// conversion from a string to a boolean
// returns TRUE == 1, FALSE == 0, and unknown == -1
extern int str2bool(const char *s);

// VMD file deletion function (portable)
int vmd_delete_file(const char *);

// VMD process sleep functions (portable)
void vmd_sleep(int);   // sleeps for N seconds
void vmd_msleep(int);  // sleeps for N milliseconds

#endif
