#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "ReadDonAcc.h"
#include "HBonds.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif


int main(int argc, char **argv) {
    const char* topname;
    const char* psfname;
    const char* patfile;
    const char* outname;
    int have_psf=0;
    int have_outname=0;
    int patches=0;
    //int i;
    int ev = 1;
    while(ev < argc)
    {
        // The psf file
        if(!strcmp(argv[ev], "-psf")) {
            if(argc > (ev + 1) && *(argv[ev+1]) != '-') {
                psfname = argv[++ev];
                have_psf = 1;
            }
        }
        // The topology file needed for h-bond calculation
        if(!strcmp(argv[ev], "-top")) {
            if(argc > (ev + 1) && *(argv[ev+1]) != '-') {
                topname = argv[++ev];
            }
        }
        // The output file name
        if(!strcmp(argv[ev], "-o")) {
            if(argc > (ev + 1) && *(argv[ev+1]) != '-') {
                outname = argv[++ev];
		have_outname = 1;
            }
        }
	// file for declaration of patches (only needed for -hbon)
	if(!strcmp(argv[ev], "-pat")) {
	    if(argc > (ev + 1) && *(argv[ev+1]) != '-') {
		patfile = argv[++ev]; 
		patches = 1;
	    }
	}
	ev++;
    }
    
    if (!have_psf)   {printf("ERROR: No PSF file given!\n"); exit(1);}

    // If no outname is given append "+hbonds.psf" to psf basename
    if (!have_outname) {
        // Length of basename
	int baselen = strrchr(psfname, '.')-psfname;
	char* basename =new char[baselen+11];
	strncpy(basename, psfname, baselen);
	strcat(basename, "+hbonds.psf");
	outname=basename;
    }

    HBonds hbonds;
    DonAcc *donacc = read_donors_and_acceptors(topname);
    hbonds.read_psf_file(psfname);
    hbonds.build_atom_status();
    hbonds.build_lists_by_atom();
    // Read the list of patches
    if (patches) hbonds.read_patches(patfile, topname, hbonds.numAtoms, donacc);

    hbonds.write_psf_file(psfname, outname, donacc);

    return 1;
}
