#define kBoltz 1.380658e-23
#define JOULE 4184        // thermochemical calorie
#define KCAL  0.000239005 // 1.0/4184
#define RANDOMSEED 12345

#define SWITCHDIST 10 
#define CUTOFF     12 
#define PAIRLISTDIST 14 
#define NONE             0
#define EXCLUDE1_2       2
#define EXCLUDE1_3       3
#define EXCLUDE1_4       4
#define EXCLUDE1_4SCALED 14
#define SCALE1_4FAC      1.0
#define CHARMM 1       // matches paraCharmm in Parameters.h
#define XPLOR  0       // matches paraXplor in Parameters.h
#define AMBER  2       
#define TEMPERATURE 300
#define BOLTZMAN 0.001987191 // kBoltz*N/(4184 J/kcal)
#define PRECISION 4

/***********************************************************/
/***                H-bonds Parameters                   ***/
/***           according to XPLOR manual p.79f           ***/
/***********************************************************/

// exponents for the Lennerd-Jones term
#define AEXP 4 // attractive potential
#define REXP 6 // repulsive potential
#define HAEX 4 // D-H-A angle term (cos exponent)
#define AAEX 2 // H-A-AA angle term (cos exponent)

// distance switching
#define DON  3.5
#define DOFF 4.5
#define DCUT 5.5
// angle switching
#define AON  40
#define AOFF 60
#define ACUT 70

/*
!                   Emin      Rmin
!                (Kcal/mol)   (A)
hbond N*+* N%      -3.00      3.0!  VALUES FROM VINOGRADOV AND LINELL FOR
hbond N*+* O*      -3.50      2.9!  TYPICAL LENGTHS AND DEPTHS.
hbond OH*  N%      -4.00      2.85
hbond OH*  O*      -4.25      2.75
hbond SH1E    N%      -3.00      3.0 !! added, ATB
hbond SH1E    O*      -3.50      2.9 !! added, ATB
*/
