// auxil.h
#ifndef AUXIL_H
#define AUXIL_H

#include <stdio.h>
#include <iostream.h>
#include "LoadDCD.h"

class Vector;
struct Energies;
struct hbond;

struct E_clientdata
{
  FILE* fd;
  int Natoms;
  int logscale;
};

struct F_clientdata
{
  FILE* fd;
  int Natoms;
  Vector* total;
};

struct Coor_clientdata
{
  FILE* fd;
  int   Natoms;
  DCD*  dcd;
};
                                                                                              

//static double time_of_day(void);
void  usage_exit(const char *s, const char *argv0);
void  error_exit(const char *s);
void  bad_energy_select_exit();
void  NAMD_die(const char *s);
void  eatwhiteleft(char *s);
void  trimfirst(char* s);
FILE* open_write(const char *B_file_name);
void  close_write(FILE* fd);
void  write_E_file_header (FILE* fd, int natoms, int* atomsel, char* seltext,
			  char* selected_energy, int navg, int self);
void  write_F_file_header (FILE* fd, int natoms, int* atomsel, char* seltext, 
			  char* selected_energy, int navg, int self);
void  write_HB_file_header(FILE* fd, int natoms, int *atomsel, char* seltext,
			  char* selected_energy, int self);
void  write_HB_step(FILE* fd, int N, int Frame, hbond *hb);
int   write_avg_energies(void* param, const void* data, int Frame);
int   write_avg_forces  (void* param, const void* data, int Frame);
int   write_avg_coords  (void* param, const void* data, int Frame);

FILE* open_read(const char *filename);
void  close_read(FILE* fd);
void  read_selection(char* selfile, int **atomsel, int *len, char** seltext);
FILE* Fopen(const char *filename, const char *mode);
int   Fclose(FILE *fout);


extern "C" 
int  compare_ints (const void *a, const void *b);


#endif
