// Selection.C

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include "Selection.h"
#include "auxil.h"
#ifdef DMALLOC
#include <dmalloc.h>
#endif

Selection::Selection()
{
    natoms=0;
    ntotal=0;
    atomsel=NULL; // allocated in read()
    seltext=NULL; // allocated in read()  
    byAtom=NULL;  // allocated in make_byatom_list()  
}

Selection::~Selection()
{
    if (atomsel) delete [] atomsel; // allocated in read()
    if (seltext) delete [] seltext; // allocated in read()  
    delete [] byAtom;  // allocated in make_byatom_list()  
}

void Selection::select_all(int natomstotal)
{
    int i;
    ntotal=natomstotal;
    natoms=ntotal;
    seltext = new char[4];
    strcpy(seltext,"all");
    atomsel = new int[ntotal];
    for (i=0; i<ntotal; i++) {
	atomsel[i] = i;
	//cout << atomsel[i] << " ";
    }

    // Generate by-atom-lists for the selection
    make_byatom_list();
}

void Selection::read(const char *selfile, int natomstotal) 
{
    ntotal=natomstotal;
    FILE* fd = open_read(selfile);
    if (fd==NULL) {
	cerr << "ERROR: Couldn't open file " << selfile << endl;
	exit(1);
    }
    int index, have_sel=0;
    size_t size;
    int  len = -1;
    char keyword[100];
    char tmp[10000];
    fscanf (fd, "%s", keyword);
    if (strcmp(keyword, "selectiontext")==0) {
	fgets(tmp, 10000, fd);
	size = strcspn(tmp, "\n"); 
	seltext = new char[size+1];
	//seltext =  (char) malloc(size+1);
	seltext[0] = '\0';
	strncat(seltext, tmp, size);
	//strncpy(seltext, tmp, size); 
	//seltext[size] = '\0';  // terminate the string
	have_sel=1;
    }
    else {
	seltext = new char[4];
	strcpy(seltext, "all");
	rewind(fd); 
    }

    eatwhiteleft(seltext);

    // count the indices
    while (!feof(fd)) {
	fscanf (fd, "%d", &index);
	len++;
	if (ferror(fd)) error_exit("ERROR reading atom selection file");
    }
    
    atomsel = new int[len];  
    
    rewind(fd);
    if (have_sel) fgets(tmp, 10000, fd);
    
    for (int i=0; i<len; i++) {
	fscanf (fd, "%d", &index);
	atomsel[i] = index;
	if (ferror(fd)) error_exit("ERROR reading atom selection file");
    } 
    close_read(fd);
    natoms=len;

    // Sort the selection indexes for faster searching in ComputeBonded.C
    qsort (atomsel, natoms, sizeof(int), compare_ints);

    // Generate by-atom-lists for the selection
    make_byatom_list();
}

void Selection::make_byatom_list()
{
    int i;
    byAtom = new int[ntotal];
    memset((void*) byAtom, 0, ntotal*sizeof(int));
    for (i=0; i<ntotal; i++) {
	if (bsearch (&i, atomsel, natoms, sizeof(int), compare_ints)) {
	  //cerr<<"SELECT: "<<i<<endl;
	    byAtom[i] = 1;
	}
    }
}

void Selection::invert_list()
{
  int i;
  for (i=0; i<ntotal; i++) {
    if (byAtom[i]) byAtom[i]=0;
    else byAtom[i]=1;
  }
}

void Selection::intersect_with_fixed(Selection *fixedatoms)
{
  int i, natomseff=0;
  for (i=0; i<ntotal; i++) {
    if (!(byAtom[i] && fixedatoms->byAtom[i]))
      byAtom[i]=0;
    else {
      byAtom[i]=1; 
      natomseff++;
    }
  }
  natoms=natomseff;
}


void Selection::checkprint() const
{
    int i;
    cout << "( ";
    for (i=0; i<natoms; i++) {
	cout << atomsel[i] << " ";
	if (atomsel[i] >= ntotal) {
	    cerr << "ERROR: Selected index = " << atomsel[i] << endl;
	    error_exit("ERROR: Bad atom selection, index too high!");
	}
    }
    cout << ")" << endl;
}

extern "C"
int compare_ints (const void *a, const void *b) {
  const int *da = (const int *) a;
  const int *db = (const int *) b;

  return (*da > *db) - (*da < *db);
}
