#ifndef RINGBUF_H
#define RINGBUF_H

/**************************************************************/
/**************************************************************/
/***                                                        ***/
/***   Ringbuf.h                                            ***/
/***                                                        ***/
/***   A ringbuffer class that manages pointers to          ***/
/***   the actual objects. The object number and size       ***/
/***   must be specified.                                   ***/
/***                                                        ***/
/***   Fill the buffer with set_next()                      ***/
/***   Navigation with get_next()                           ***/
/***                                                        ***/
/***                                                        ***/
/**************************************************************/
/**************************************************************/

#include <stdlib.h>

class Ringbuf {
 private: 
  char  **buf;
  int    ptr;
  int    len;
  int    element_size;
  
 public:
  Ringbuf();
  Ringbuf(int n, size_t elem_size);
  ~Ringbuf();
  void  init(int n, size_t elem_size);
  int   length();
  void  get_next(void* elem);
  void  set_next(const void* elem);
  void  shift(int);
  void  shift_to_origin() { ptr = 0; };
};

#endif
