#ifndef MDEBASE_H
#define MDEBASE_H

#include "global.h"
#include "Mindy.h"
#include "PDB.h"
#include "LoadDCD.h"
#include "Selection.h"

#define DCD_COOR 0
#define PDB_COOR 1
#define VMD_COOR 2

class HBonds;
class Parameters;

struct Coordset {
    char* source;
    int type;
    int num;
    struct Coordset *next;
};

class MDEBase {
    const char *fend_string;
    void add_to_coord_list(struct Coordset* &coord_set, struct Coordset* &cur_coord,
			   char* source, int type);
 public:
    unsigned eflag;
    int have_hpar, patches, verbose, self, servermode;
    int have_psf, have_par, have_amber, have_efile, have_ffile;
    int have_hbfile, avg_over_frames, navg, logarithmic, have_sel, have_fixed;
    int natoms, vel_natoms, nframes, fbeg, fend;
    int dcd_time, dcd_dt, smoothing, ramping, padding, paratype;
    int numcoords, numvel;
    char *selected_energy;
    FILE* E_file;
    FILE* F_file;
    FILE* HB_file;
    SimParameters simparams; 
    char *parfile;
    const char *efile;
    const char *ffile;
    const char *hbfile;
    const char *hparfile;
    const char *patfile;
    const char *psfname;
    const char *fixedatomsfile;
    PDB* pdb;
    DCD* dcd;
    DCD* veldcd; 
    DCD dcd_write;
    Coordset* coordset;
    Coordset* curcoord;
    Coordset* velset;
    Coordset* curvel;
    Parameters *hbpar;
    int sel_natoms; 
    Selection selection[2];
    Selection fixedatoms;

    MDEBase();
    ~MDEBase();
    void getarguments(int argc, char** argv);
    void init_outfiles();
    void init_coords();
    void build_hbonds(Molecule* mol);
    void print_donors(Molecule* mol);
    void print_acceptors(Molecule* mol);
    Timestep* get_coordinates();
};


#endif
