#ifndef ENERGIES_H
#define ENERGIES_H

// Energies.h

#include <stdio.h>

// These are defines for values that can be bitwise compared
// with eflag. This is an efficient multi comparison mechanism.
#define EBOND  1
#define EANGL  2
#define EDIHE  4
#define EIMPR  8
#define EVDW   16
#define EELEC  32
#define ENONB  48        // EVDW  | EELEC
#define ECONF  15        // EBOND | EANGL | EDIHE | EIMPR
#define EALL   63        // ECONF | ENONB
#define EKIN   64
#define ENERGY 127       // EALL | EKIN
#define HBOND  128
#define FBOND  256
#define FANGL  512
#define FDIHE  1024
#define FIMPR  2048
#define FCONF  3840      // FBOND | FANGL | FDIHE | FIMPR
#define FVDW   4096
#define FELEC  8192
#define FNONB  12288     // FELEC | FVDW
#define FTOT   16128     // FCONF | FVDW | FELEC
#define FORCE  16128     // FCONF | FVDW | FELEC
#define EFNONB 12336     // ENONB | FNONB
#define EFCONF  3855     // ECONF | FCONF

// Indices for the total Energy vector E
#define BOND  0
#define ANGL  1
#define DIHE  2
#define IMPR  3
#define VDW   4
#define ELEC  5
#define NONB  6        // EVDW  | EELEC
#define CONF  7        // EBOND | EANGL | EDIHE | EIMPR
#define TOT   8        // ECONF | ENONB
#define KIN   9
#define HBON  10
#define TEMP  11
#define F_BOND 12
#define F_ANGL 13
#define F_DIHE 14
#define F_IMPR 15
#define F_CONF 16
#define F_VDW  17
#define F_ELEC 18
#define F_NONB 19
#define F_TOT  20

// Number of energy types = size of vector E
#define NUME  21


class Molecule;
class Vector;

struct Energies {
  double bond;
  double angle;
  double dihed;
  double improp;
  double vdw;
  double elec;
  double nonb;
  double kin;
  double conf;
  double tot;
  double hbon;
  double temperature;
};

struct Etot_clientdata
{
  int      time;
  int      frame0;
  int      dt;
  int      fbeg;
  unsigned eflag;
};

int  count_output_energies(unsigned eflag);
void print_energy_titles(unsigned eflag);
void print_total_energies(Energies E, int t, int frame, unsigned eflag);
int  print_energy_output(void* param, const void* data, int Frame);

class EnergiesByAtom {
 private:
  int natoms;
  int sel_natoms;
  int *dof;      // nbonds+nangles+ndihed+nimprop
  int *atomsel;  // index list of selected atoms
  Molecule *mol;

 public:
  double *B;    // Bond
  double *A;    // Angle
  double *D;    // Dihedral
  double *I;    // Improper
  double *vdw;  // VDW energy
  double *elec; // Elec. energy
  double *nonb; // Hbond energy
  double *kin;  // Kin. energy
  double *tot;  // Tot. energy
  double *conf;  // konf. energy
  float  *value; // B-values


  EnergiesByAtom(Molecule *molptr, int natoms, int sel_n, int *selptr);
  ~EnergiesByAtom();
  void   compute_dof_by_atom();
  double compute_kinetic(Vector *vel);
  void   compute_conf_and_total();
  //void   select_atoms(int* sel);
};


class ForcesByAtom {
 private:
  int natoms;
  int sel_natoms;
  int *atomsel;  // index list of selected atoms
  Molecule *mol;

 public:
  Vector *B;    // Bond
  Vector *A;    // Angle
  Vector *D;    // Dihedral
  Vector *I;    // Improper
  Vector *vdw;  // VDW force
  Vector *elec; // Elec. force
  Vector *nonb; // Hbond force
  Vector *tot;  // Tot. force
  Vector *conf;  // conf. force
  Vector *value; // output force
  double *abs;   // absolute force value


  ForcesByAtom(Molecule *molptr, int natoms, int sel_n, int *selptr);
  ~ForcesByAtom();
  void compute_absolute_forces(Vector* f_ptr);
  void compute_conf_and_total();
  //void   select_atoms(int* sel);
};

#endif
