
#ifndef COMPUTE_NONBONDED_H__
#define COMPUTE_NONBONDED_H__

class Molecule;
class Parameters;
class Vector;
class LJTable;
class DATable;
class HBonds;
struct SimParameters;
struct hbond;

struct Pair {
  const Vector *pos1;
  const Vector *pos2;
  double kqq;   // The electrostatic factor
  double vdwA;
  double vdwB;
};

struct hbond {
  int don;
  int acc;
  Vector *posDon;
  Vector *posAcc;
  //int count;
  double E;
  struct hbond *next;
  struct hbond *prev;
};

#define COULOMB 332.0636

class ComputeNonbonded {
public:
  ComputeNonbonded(const Molecule *, const Parameters *, const Parameters *,
		   const SimParameters *, int *selByAtom, int have_sel);
  ~ComputeNonbonded();

  void compute( Molecule *mol, const Vector *pos, Vector *vdwf, Vector *elecf, double *evdw,
		double *eelec, hbond **hbondlist, double& Evdw, double &Eelec,
		double &Ehbon, Vector &Fvdw, Vector &Felec, const int *selectionByAtom,
		const int *selection2ByAtom, int have_sel); 
  double HB_energy(double A, double B, double rAD, double theta_DHA, double theta_HAAA);
  double rswit(double r);
  double aswit(double a);
  void   add_to_hbond_list(int don, int acc, Vector posDon, Vector posAcc, double E);
  void   free_hbond_list(struct hbond *last);
  struct hbond *get_cur_node() { return cur_node; };
  void   request_energies(unsigned eflags, int self, int verbose) { 
      request=eflags; selfonly=self; this->verbose=verbose;
  };
  int    get_numHbonds() const { return numHbonds; };
  struct hbond *get_hbondlist() const { return hbond_list; };
  int    get_don() const { return hbond_list->don; };
private:
  int      natoms, exclude;
  unsigned request;  // requested energies
  double   cut2;
  double   switch2;
  double   pair2;
  double   scale14fac;
  //int*     selectionByAtom;
  int      selshift, selfonly, verbose;

  // vdW switching
  double c1, c3;
  LJTable *ljTable; // vdw parameter table

  DATable *daTable; // donor-acceptor parameter table for hbonds
  int numHbonds;

  // linked list to hold hbond energies
  struct hbond *hbond_list; // first node
  struct hbond *cur_node;   // current node
  struct hbond *prev_node;  // previous node
};

#endif

