#!/usr/bin/env perl

# Leonardo Trabuco - Tue, 08 Aug 2006
# ltrabuco@ks.uiuc.edu

use warnings;

#######################################################################
#
# Change the following line to the complete path of ionize

 $ionize = "../src/ionize";
# $ionize = "/home/ltrabuco/ionize/peter/ionize";

#######################################################################
  
# Defaults
$nions = 1;
$r_ion_solute = 6;
$r_ion_ion = 10;
$grid = 0.5;
$border = 10;
$ion_name = "SOD";
$ion_charge = 1;
$max_proc = 1;

# We expect a single argument
if ($#ARGV != 0) {
  print "Usage: runionize config_file\n";
  exit 1;
}

open(CONF, "$ARGV[0]") or die "Can't open $ARGV[0]: $!";

$nline = 0;

while (<CONF>) {

  chomp;
  $nline++;

  SWITCH: {
    if (/^#|^\s*$/) { 
      last SWITCH; 
    }
    if (/^(NUM_IONS)\s+(\d+)/) { 
      $nions = $2;
      last SWITCH; 
    }
    if (/^(R_ION_PRODNA|R_ION_SOLUTE)\s+(\d+\.?\d?)/) { 
      $r_ion_solute = $2;
      last SWITCH; 
    }
    if (/^(R_ION_ION)\s+(\d+\.?\d?)/) { 
      $r_ion_ion = $2;
      last SWITCH; 
    }
    if (/^(GRID_STEP)\s+(\d+\.?\d?)/) { 
      $grid = $2;
      last SWITCH; 
    }
    if (/^(BORDER_WIDTH)\s+(\d+\.?\d?)/) { 
      $border = $2;
      last SWITCH; 
    }
    if (/^(PDB_NAME)\s+(\S+)/) { 
      $input = $2;
      last SWITCH;
    }
    if (/^(PDB_OUT)\s+(\S+)/) { 
      $output = $2;
      last SWITCH;
    }
    if (/^(ION_NAME)\s+(\S+)/) { 
      $ion_name = $2;
      last SWITCH;
    }
    if (/^(ION_CHARGE)\s+(\d+.?\d?)/) { 
      $ion_charge = $2;
      last SWITCH; 
    }
    if (/^(MAX_PROC)\s+(\d+)/) {
      $max_proc = $2;
      last SWITCH;
    }
    print "Bad config file entry at line $nline\n";
    exit 1;
  }

}

system("$ionize -n $nions -r $r_ion_solute -i $r_ion_ion -g $grid -b $border -t $ion_name -q $ion_charge -p $max_proc $input $output");

close(CONF);

