#ifndef DCD_READER_H__
#define DCD_READER_H__

#include <stdio.h>
#include "readdcd.h"

typedef struct {
  FILE *fd;     /* file descriptor for the dcd file  */
  int N;        /* Number of atoms */
  int NSET;     /* Number of sets of coordinates */
  int ISTART;
  int NSAVC;
  double DELTA;
  int NAMNF;
  int *FREEINDEXES;
  int reverseEndian;
  int charmm;
} DCDhandle;

int dcd_read_open(DCDhandle *, const char *filename);
int dcd_read_step(DCDhandle *, int frame, float *x, float *y, float *z);
void dcd_read_close(DCDhandle *);

int dcd_write_open(DCDhandle *, const char *filename);
int dcd_write_step(DCDhandle *, 
                   const float *x, const float *y, const float *z);
void dcd_write_close(DCDhandle *);

#endif

