
#include "dcdreader.h"
#include "readdcd.h"

int dcd_read_open(DCDhandle *h, const char *filename) {
  h->fd = fopen(filename, "r");
  if (h->fd == NULL) return DCD_OPENFAILED;
  
  return read_dcdheader(h->fd, &h->N, &h->NSET, &h->ISTART, &h->NSAVC,
    &h->DELTA, &h->NAMNF, &h->FREEINDEXES, &h->reverseEndian, &h->charmm);
}

int dcd_read_step(DCDhandle *h, int frame, float *x, float *y, float *z) {
  return read_dcdstep(h->fd, h->N, x, y, z, h->NAMNF, frame==h->ISTART,
                      h->FREEINDEXES, h->reverseEndian, h->charmm);
}

void dcd_read_close(DCDhandle *h) {
  close_dcd_read(h->fd, h->NAMNF, h->FREEINDEXES);
}

int dcd_write_open(DCDhandle *h, const char *filename) {
  if ((h->fd = fopen(filename, "w+b")) == NULL) 
    return DCD_OPENFAILED;
  return write_dcdheader(h->fd, filename, h->N, h->NSET, h->ISTART,
                         h->NSAVC, h->DELTA);
}

int dcd_write_step(DCDhandle *h, 
                   const float *x, const float *y, const float *z) {
  return write_dcdstep(h->fd, h->N, x, y, z);
}

void dcd_write_close(DCDhandle *h) {
  fclose(h->fd);
}

