
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "dcdreader.h"

#define INIT_NUM_INDICES 4

static int svd_indices(const char *fname, int **indices) {
  int num, max, retval;
  int *ind;
  FILE *fd;

  max = INIT_NUM_INDICES;
  ind = (int *)malloc(INIT_NUM_INDICES*sizeof(int));
  num= 0;
  fd = fopen(fname, "r");
  if (fd == NULL) {
    printf("error opening index file %s\n",fname);
    return 0;
  }
  while ((retval = fscanf(fd, "%d",ind + num)) == 1) {
    num++;
    if (num== max) {
      int *tmp;
      max *= 2;
      tmp = (int *)realloc(ind, max*sizeof(int));
      ind = tmp;
    }
  }
  fclose(fd);
  *indices = ind;
  return num;
}

int main(int argc, char *argv[]) {

  DCDhandle h_in, h_out;
  int retval;
  float *x, *y, *z, *xout, *yout, *zout;
  int i, firstfile, ifile, nset;
  int num_ind, *ind;

  if (argc < 3) {
    printf("Usage: %s outputfile inputfile1 inputfile2 ... \n",argv[0]);
    return 1;
  }

  firstfile = 2; /* argv[firstfile] will be the first input file */
  num_ind = 0;
  if (!strcmp(argv[2],"-i")) {
    printf("reading indices from %s\n",argv[3]);
    num_ind = svd_indices(argv[3], &ind);
    if (num_ind < 1) {
      printf("Error: no indices read from file %s; exiting...\n",argv[3]);
      free(ind);
      return 1;
    }
    firstfile += 2;
  }
 
  /* 
   * Open the input dcd files so we can read its header.  Need to know how
   * many timesteps there will be, and it's also a good idea to make sure all
   * the files are present and readable before we start filling up the disk...
   */ 

  nset = 0;
  for (ifile=firstfile; ifile < argc; ifile++) {
    memset(&h_in, 0, sizeof(DCDhandle));
    retval = dcd_read_open(&h_in, argv[ifile]);
    if (retval) {
      printf("failure opening %s, returned %d\n",argv[ifile], retval);
      return 1;
    }
    nset += h_in.NSET;
    dcd_read_close(&h_in);
  }

  h_out.N = num_ind ? num_ind : h_in.N;
  h_out.NSET = nset;
  h_out.ISTART = 0;
  h_out.NSAVC = h_in.NSAVC;
  h_out.DELTA = h_in.DELTA;
 
  dcd_write_open(&h_out, argv[1]);
  printf("opened file %s for writing %d steps with %d atoms\n",argv[1],
    h_out.NSET, h_out.N);
 
  x = (float *)malloc(h_in.N * sizeof(float));
  y = (float *)malloc(h_in.N * sizeof(float));
  z = (float *)malloc(h_in.N * sizeof(float));
  xout = (float *)malloc(h_out.N * sizeof(float));
  yout = (float *)malloc(h_out.N * sizeof(float));
  zout = (float *)malloc(h_out.N * sizeof(float));

  for (ifile=firstfile; ifile<argc; ifile++) {
    memset(&h_in, 0, sizeof(DCDhandle));
    retval = dcd_read_open(&h_in, argv[ifile]);
    if (retval) {
      printf("failure opening %s, returned %d\n",argv[ifile], retval);
      return 1;
    }
    printf("writing %d steps from file %s\n",h_in.NSET, argv[ifile]);
    for (i=0; i<h_in.NSET; i++) {
      dcd_read_step(&h_in, h_in.ISTART + i*h_in.NSAVC, x,y,z);
      if (num_ind) {
        int j;
        for (j=0; j<num_ind; j++) {
          xout[j] = x[ind[j]];
          yout[j] = y[ind[j]];
          zout[j] = z[ind[j]];
        }
        dcd_write_step(&h_out, xout, yout, zout);
      } else {
        dcd_write_step(&h_out, x, y, z);
      }
    }
    dcd_read_close(&h_in);
  }
  dcd_write_close(&h_out);

  free(x); 
  free(y); 
  free(z); 
  free(xout); 
  free(yout); 
  free(zout); 
  free(ind);
  return 0;
}

