/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module data wrapper subprogram for module SimpleSphere.
 * Automatically created by module builder at Wed Jan 13 11:59:22 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxGeometry.api.h>

/* No user specified include files. */



  /* --- User Fcn call prototype. --- */
#include <cx/cxParameter.api.h>
#include <cx/cxGeometry.api.h>

#ifdef __cplusplus
	extern "C" {
#endif

  void 	sphere  (
	 double 	  radius, 
	 cxGeometry *	* geom, 
	 long   	  color, 
	 double 	  value );

#ifdef __cplusplus
}
#endif


/* Number of user function arguments. */
#define cxMDWNARGsphere 4

long cxMDWsphere( )
{

/* ----- Beginning of port declarations ----- */

/* Port dataset variable declarations */

  cxParameter *cxP_In_Radius;
  cxParameter *cxP_In_Color;
  cxParameter *cxP_In_Color_Value;
  cxGeometry *cxP_Out_Output;

/* --- End of port and dataset declarations ---- */


/* -- Beginning of User Fcn variable declarations -- */

  double  radius; 
  cxGeometry * geom; 
  long    color; 
  double  value; 

/* ------ End of User Fcn declarations ------ */

  long   cxMDWi, cxMDWIrc;
  long   cxMDWIfCoerce[ cxMDWNARGsphere ];
  char *cxMDWStr;
  long  cxMDWFuncRetCode;
  char  cxMDWFuncBuf[256];
  long  cxMDWLen;
  long  cxMDWPortIDIn[3];
  long  cxMDWPortIDOut[1];
  void *tmp;
  int  *cxMDWTypeTab;
  cxDataCheckErrorInfo  *cxMDWCheckErr;
  cxErrorCode   ec;
/* ------------------------------------------ */
/* ----- Beginning of Port Associations ----- */

/* -------- First executable statment ------- */


  /* Get input port handles. */ 
  cxMDWPortIDIn[0] = cxInputPortOpen( "Radius" );
  cxMDWPortIDIn[1] = cxInputPortOpen( "Color" );
  cxMDWPortIDIn[2] = cxInputPortOpen( "Color Value" );

  /* Get output port handles. */ 
  cxMDWPortIDOut[0] = cxOutputPortOpen( "Output" );

  /* Get dataset pointers. */ 
  cxP_In_Radius = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[0] );
  cxP_In_Color = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[1] );
  cxP_In_Color_Value = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[2] );

  /* Initialize the coercion status flags. */
  for (cxMDWi=0; cxMDWi< cxMDWNARGsphere; cxMDWi++) 
    cxMDWIfCoerce[cxMDWi] = TRUE;


  /* Assign user function values. */
  /* Extracting User Function variables from ports. */

  if (0 && !cxP_In_Radius) {
    radius = NULL;
    cxMDWIfCoerce[0] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Radius, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Radius, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    radius = *(double  *) tmp;

    cxMDWIfCoerce[0] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Color) {
    color = NULL;
    cxMDWIfCoerce[2] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Color, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Color, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    color = *(long    *) tmp;

    cxMDWIfCoerce[2] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Color_Value) {
    value = NULL;
    cxMDWIfCoerce[3] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Color_Value, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Color_Value, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    value = *(double  *) tmp;

    cxMDWIfCoerce[3] = FALSE;
    cxVecDel( tmp );
  }
  /* Assigning constant User Function variables. */
  /* Assigning whether data has changed to User Function variables. */
  /* Allocation of User Function variables. */
  geom = (cxGeometry *) NULL; 

  sphere( radius, 
      &geom, color, value );

  if (cxDataAllocErrorGet())
    return( cx_err_error );

/* Beginning of output port assembly. */

  /* Output port assembly for port "Output". */

  cxP_Out_Output = (cxGeometry *) geom;

/* End of output port assembly. */


/* Free temporarily assigned user vars. */

  cxOutputDataSet( cxMDWPortIDOut[0], (void *)cxP_Out_Output );
  return( cx_err_none );
}
