.TH PROJECTOR 1EXP
.SH NAME
Projector
.SH DESCRIPTION
.PP
The Projector module is designed to transform data with 
geographic coordinates into one of several standard map projections.
.PP
The Projector module has input ports for several pyramids and 
lattices and modifies the coordinates of its input to produce a projection. 
The first pyramid is designated the map and its z coordinate may be 
transformed to place the map above or below the data.
.PP
All lattices (including the base lattices of the pyramids) are 
assumed to have three coordinate variables. Any lattice with uniform or 
perimeter coordinates is also assumed to be three dimensional. All 
coordinates are assumed to represent longitude, latitude, and altitude 
(depths should be negative values). Longitude and latitude should be in 
degrees. Longitude may take on any value, but should be consistently 
within a range of 360 degrees and the Base Longitude parameter (see 
below) should be set to compensate.
.SH INPUTS
.TP
.BI "Map" " -- Pyramid (Opt.)"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Map pyramid to be transformed.  The z coordinates of this
pyramid will have the value of "Map z" added to them.
.TP
.BI "Pyramid 1" " -- Pyramid (Opt.)"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Second pyramid to be transformed.
.TP
.BI "Pyramid 2" " -- Pyramid (Opt.)"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Third pyramid to be transformed.
.TP
.BI "Pyramid 3" " -- Pyramid (Opt.)"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Fourth pyramid to be transformed.
.TP
.BI "Lattice 1" " -- Lattice (Opt.)"
First lattice to be transformed.
.TP
.BI "Lattice 2" " -- Lattice (Opt.)"
Second lattice to be transformed.
.SH WIDGETS
.TP
.BI "Projection" " -- Option Menu"
Selects the particular map projection to be applied.
.sp
The implemented projections are listed below along with a brief 
explanation of their properties, utility, and parameters. Projections are 
classified according to their properties. A projection may be conformal, 
preserving the shapes of structures while distorting their scale, 
equivalent, preserving the area of structures, or equidistant, preserving 
distances in one or more directions. A Projection may also be azimuthal, 
based on some projection of the globe onto a plane tangent at one point, 
cylindrical, based on the projection of the globe onto a cylinder tangent 
(usually) at the equator, or conic, based on the projection of the globe 
onto a cone which intersects the globe at one or two standard parallels.
.sp
Available Projections 
.sp
Cartesian
.sp
 Parameters: Base Long., Base Lat.
 Properties: None
.sp
Longitude and Latitude map directly to x and y except that they are 
scaled to make equatorial and meridian distances correct in proportion to 
altitudes. This projection is seldom seen on maps, is considered 
cylindrical, and preserves no particular quality. 
The parameters only set the center of the map.
.sp
Mercator Cylindrical
.sp
 Parameters: Base Long., Base Lat.
 Properties: Conformal
.sp
This is the standard Mercator projection. It is a cylindrical conformal 
projection.
This projection goes to infinity as latitude 
approaches the poles, therefore such data should be cropped.
The parameters only set the center of the map.
.sp
Lambert Cylindrical
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equivalent
.sp
This is an equivalent projection.
Structures at the poles 
become flat in this projection.
The parameters only set the center of the map.
.sp
Gnomonic Azimuthal
.sp
 Parameters: Base Long., Base Lat.
 Properties: None
.sp
Projection is made from a perspective point at the center of the globe 
onto a plane which is tangent to the globe at (Base Longitude, Base 
Latitude). As with all azimuthal projections, great circles on the globe 
passing through the tangent point appear as straight lines radiating from 
it. This is the simplest azimuthal projection but has no special 
properties. Care should be taken in cropping data to avoid points which 
appear on the other side of the world from the tangent point, as this will 
produce undesirable results.
.sp
Stereographic Azimuthal
.sp
 Parameters: Base Long., Base Lat.
 Properties: Conformal
.sp
Projection is made as above but from a perspective point on the surface 
of the globe exactly opposite the tangent point. This projection has the 
added property of being conformal. As above, all data points should be 
on the same side of the globe as the tangent point.
.sp
Orthonormal Azimuthal
.sp
 Parameters: Base Long., Base Lat.
 Properties: None
.sp
Projection is made onto a plane as above from a point at infinity. This 
projection gives the effect of looking a a globe, but the projection is flat. 
Data points should be on the same side of the globe as the tangent point. 
To achieve the effect of looking at a globe, the actual Globe projection is 
recommended.
.sp
Postel Azimuthal
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equidistant
.sp
Also known as the azimuthal equidistant projection, this is useful for 
determining distances from a given origin. The distance from the point 
(Base Longitude, Base Latitude) to any other point on the map will be 
equal to that actual distance on the surface of the earth.
.sp
Lambert Azimuthal
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equivalent
.sp
Lambert's azimuthal equivalent projection. There is no distortion of area 
and the minimal distortion of shape occurs at the base point.
.sp
Lambert Conical
.sp
 Parameters: Base Long. & Lat., 1st. & 2nd. St. Par.
 Properties: Conformal
.sp
Lambert's conformal conical projection. Minimal distortion of area 
occurs at in the region between the 1st. Standard Parallel and the 2nd. 
Standard Parallel. 
The Base Longitude and Latitude parameters set the center of the map.
.sp
Albers Conical
.sp
 Parameters: Base Long. & Lat., 1st. & 2nd. St. Par.
 Properties: Equivalent
.sp
Albers' equivalent projection. Minimal distortion of shape occurs at in 
the region between the 1st. Standard Parallel and the 2nd. Standard 
Parallel. The Base Longitude and Latitude parameters set the center 
the map. An interesting property of this projection is that 
the pole maps to a section of a circle, effectively truncating the cone.
.sp
Cassini-Soldner
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equidistant
.sp
This is a cylindrical equidistant projection in which the cylinder lies at a 
right angle to the earth's axis. It is useful only for areas which extend 
mainly in the north-south direction. The Base Longitude parameter sets 
the meridian of contact for the cylinder and horizontal distances from 
this central meridian are correct.  The Base Latitude parameter sets the
center of the map.  Distortion occurs mostly in the vertical 
direction and increases with distance from the central meridian.
.sp
Bonne Conical
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equivalent
.sp
Actually Bonne's pseudo conical equivalent projection. Scale is 
preserved only on the central meridian, set by the Base Longitude 
parameter, and along the parallels. Minimal shape distortion is achieved 
along the Base Latitude. This projection produces highly curved maps 
which are useful mainly for projections of an entire hemisphere.
.sp
Werner
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equivalent
.sp
The Werner projection produces an equivalent heart shaped map, 
centered on the Base Longitude and is actually a form of Bonne's 
projection. The Base Latitude determines which hemisphere is at 
the top of the heart and sets the center of the map.
Useful for viewing the entire globe.
.sp
Sanson-Flamsteed
.sp
 Parameters: Base Long., Base Lat.
 Properties: Equivalent
.sp
The Sanson-Flamsteed projection produces an equivalent symmetric 
map, centered on the Base Longitude and the equator. This is also a 
form of Bonne's projection and is useful for viewing the entire globe.
The Base Latitude parameter sets the center of the map.
.sp
Globe
.sp
 Parameters: None
 Properties: No distortion
.sp
This produces an actual three-dimensional globe with radius Globe 
Radius. If necessary (as when displaying the entire globe) the module 
SimpleSphere may be used to place a sphere inside the globe in order to 
avoid seeing through it.
.sp
.TP
.BI "Globe Radius" " -- Text"
Radius of the earth in the same units as the altitudes in the data set. This 
parameter is used in all map projections to provide proper scaling of 
longitude and latitude.
.TP
.BI "Map z" " -- Text"
Sets the amount the first pyramid (the Map) 
will be shifted in the positive z direction. This allows the map (which is 
usually at z=0) to be placed, for example, above air masses or below 
seismic data.
.TP
.BI "Base Long." " -- Dial"
Sets the 
point on the globe which will be the center of the map. This is important 
because this is usually the area with the least distortion. The Base 
Longitude parameter may take on any value, but should be in the same 
range as the data.
.TP
.BI "Base Lat." " -- Dial"
Sets the 
point on the globe which will be the center of the map. This is important 
because this is usually the area with the least distortion. 
The Base Latitude parameter is limited to the range [-90,90].
.TP
.BI "1st. St. Par." " -- Dial"
The 1st. and 2nd. Standard Parallels are used by the conic 
projections to indicate the intersection of the cone with the earth. These 
parameters should be chosen to border the area of interest and the 1st. 
should be greater than or equal to the 2nd. If they are equal, the cone 
will only touch the earth and not penetrate it.
.TP
.BI "2nd. St. Par." " -- Dial"
See above.
.SH OUTPUTS
.TP
.BI "Map" " -- Pyramid"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Map pyramid after transformation.
.TP
.BI "Pyramid 1" " -- Pyramid"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Second pyramid after transformation.
.TP
.BI "Pyramid 2" " -- Pyramid"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Third pyramid after transformation.
.TP
.BI "Pyramid 3" " -- Pyramid"
(1..-layer, 1..-baseLat, n-D compression, none-compression type).
Fourth pyramid after transformation.
.TP
.BI "Lattice 1" " -- Lattice"
First lattice after transformation.
.TP
.BI "Lattice 2" " -- Lattice"
Second lattice after transformation.
.SH KNOWN PROBLEMS
None.
.SH SEE ALSO
BendBox, WorldCrop, WorldMap.
