/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module data wrapper subprogram for module CoordCrop.
 * Automatically created by module builder at Wed Jan 13 11:40:29 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxLattice.api.h>

/* No user specified include files. */



  /* --- User Fcn call prototype. --- */
#include <cx/cxParameter.api.h>
#include <cx/cxLattice.api.h>

#ifdef __cplusplus
	extern "C" {
#endif

  void 	coordcrop  (
	 double 	  xMin, 
	 double 	  xMax, 
	 double 	  yMin, 
	 double 	  yMax, 
	 double 	  zMin, 
	 double 	  zMax, 
	 cxLattice *	  lat1In, 
	 cxLattice *	* lat1Out, 
	 cxLattice *	  lat2In, 
	 cxLattice *	* lat2Out, 
	 cxLattice *	  lat3In, 
	 cxLattice *	* lat3Out );

#ifdef __cplusplus
}
#endif


/* Number of user function arguments. */
#define cxMDWNARGcoordcrop 12

long cxMDWcoordcrop( )
{

/* ----- Beginning of port declarations ----- */

/* Port dataset variable declarations */

  cxParameter *cxP_In_x_Min;
  cxParameter *cxP_In_x_Max;
  cxParameter *cxP_In_y_Min;
  cxParameter *cxP_In_y_Max;
  cxParameter *cxP_In_z_Min;
  cxParameter *cxP_In_z_Max;
  cxLattice *cxP_In_Lattice_1;
  cxLattice *cxP_In_Lattice_2;
  cxLattice *cxP_In_Lattice_3;
  cxLattice *cxP_Out_Lattice_1;
  cxLattice *cxP_Out_Lattice_2;
  cxLattice *cxP_Out_Lattice_3;

/* --- End of port and dataset declarations ---- */


/* -- Beginning of User Fcn variable declarations -- */

  double  xMin; 
  double  xMax; 
  double  yMin; 
  double  yMax; 
  double  zMin; 
  double  zMax; 
  cxLattice * lat1In; 
  cxLattice * lat1Out; 
  cxLattice * lat2In; 
  cxLattice * lat2Out; 
  cxLattice * lat3In; 
  cxLattice * lat3Out; 

/* ------ End of User Fcn declarations ------ */

  long   cxMDWi, cxMDWIrc;
  long   cxMDWIfCoerce[ cxMDWNARGcoordcrop ];
  char *cxMDWStr;
  long  cxMDWFuncRetCode;
  char  cxMDWFuncBuf[256];
  long  cxMDWLen;
  long  cxMDWPortIDIn[9];
  long  cxMDWPortIDOut[3];
  void *tmp;
  int  *cxMDWTypeTab;
  cxDataCheckErrorInfo  *cxMDWCheckErr;
  cxErrorCode   ec;
/* ------------------------------------------ */
/* ----- Beginning of Port Associations ----- */

/* -------- First executable statment ------- */


  /* Get input port handles. */ 
  cxMDWPortIDIn[0] = cxInputPortOpen( "x Min" );
  cxMDWPortIDIn[1] = cxInputPortOpen( "x Max" );
  cxMDWPortIDIn[2] = cxInputPortOpen( "y Min" );
  cxMDWPortIDIn[3] = cxInputPortOpen( "y Max" );
  cxMDWPortIDIn[4] = cxInputPortOpen( "z Min" );
  cxMDWPortIDIn[5] = cxInputPortOpen( "z Max" );
  cxMDWPortIDIn[6] = cxInputPortOpen( "Lattice 1" );
  cxMDWPortIDIn[7] = cxInputPortOpen( "Lattice 2" );
  cxMDWPortIDIn[8] = cxInputPortOpen( "Lattice 3" );

  /* Get output port handles. */ 
  cxMDWPortIDOut[0] = cxOutputPortOpen( "Lattice 1" );
  cxMDWPortIDOut[1] = cxOutputPortOpen( "Lattice 2" );
  cxMDWPortIDOut[2] = cxOutputPortOpen( "Lattice 3" );

  /* Get dataset pointers. */ 
  cxP_In_x_Min = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[0] );
  cxP_In_x_Max = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[1] );
  cxP_In_y_Min = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[2] );
  cxP_In_y_Max = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[3] );
  cxP_In_z_Min = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[4] );
  cxP_In_z_Max = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[5] );
  cxP_In_Lattice_1 = ( cxLattice *) cxInputDataGet( cxMDWPortIDIn[6] );
  cxP_In_Lattice_2 = ( cxLattice *) cxInputDataGet( cxMDWPortIDIn[7] );
  cxP_In_Lattice_3 = ( cxLattice *) cxInputDataGet( cxMDWPortIDIn[8] );

  /* Initialize the coercion status flags. */
  for (cxMDWi=0; cxMDWi< cxMDWNARGcoordcrop; cxMDWi++) 
    cxMDWIfCoerce[cxMDWi] = TRUE;


  /* Assign user function values. */
  /* Extracting User Function variables from ports. */

  if (0 && !cxP_In_x_Min) {
    xMin = NULL;
    cxMDWIfCoerce[0] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_x_Min, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_x_Min, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    xMin = *(double  *) tmp;

    cxMDWIfCoerce[0] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_x_Max) {
    xMax = NULL;
    cxMDWIfCoerce[1] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_x_Max, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_x_Max, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    xMax = *(double  *) tmp;

    cxMDWIfCoerce[1] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_y_Min) {
    yMin = NULL;
    cxMDWIfCoerce[2] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_y_Min, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_y_Min, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    yMin = *(double  *) tmp;

    cxMDWIfCoerce[2] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_y_Max) {
    yMax = NULL;
    cxMDWIfCoerce[3] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_y_Max, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_y_Max, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    yMax = *(double  *) tmp;

    cxMDWIfCoerce[3] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_z_Min) {
    zMin = NULL;
    cxMDWIfCoerce[4] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_z_Min, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_z_Min, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    zMin = *(double  *) tmp;

    cxMDWIfCoerce[4] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_z_Max) {
    zMax = NULL;
    cxMDWIfCoerce[5] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_z_Max, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_z_Max, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    zMax = *(double  *) tmp;

    cxMDWIfCoerce[5] = FALSE;
    cxVecDel( tmp );
  }

  if (1 && !cxP_In_Lattice_1) {
    lat1In = NULL;
    cxMDWIfCoerce[6] = FALSE;
  }
  else {
  lat1In = (cxLattice *) cxP_In_Lattice_1;
  }

  if (1 && !cxP_In_Lattice_2) {
    lat2In = NULL;
    cxMDWIfCoerce[8] = FALSE;
  }
  else {
  lat2In = (cxLattice *) cxP_In_Lattice_2;
  }

  if (1 && !cxP_In_Lattice_3) {
    lat3In = NULL;
    cxMDWIfCoerce[10] = FALSE;
  }
  else {
  lat3In = (cxLattice *) cxP_In_Lattice_3;
  }
  /* Assigning constant User Function variables. */
  /* Assigning whether data has changed to User Function variables. */
  /* Allocation of User Function variables. */
  lat1Out = (cxLattice *) NULL; 
  lat2Out = (cxLattice *) NULL; 
  lat3Out = (cxLattice *) NULL; 

  coordcrop( xMin, 
      xMax, yMin, yMax, zMin, 
      zMax, lat1In, &lat1Out, lat2In, 
      &lat2Out, lat3In, &lat3Out );

  if (cxDataAllocErrorGet())
    return( cx_err_error );

/* Beginning of output port assembly. */

  /* Output port assembly for port "Lattice 1". */

  cxP_Out_Lattice_1 = (cxLattice *) lat1Out;



  /* Output port assembly for port "Lattice 2". */

  cxP_Out_Lattice_2 = (cxLattice *) lat2Out;



  /* Output port assembly for port "Lattice 3". */

  cxP_Out_Lattice_3 = (cxLattice *) lat3Out;



/* End of output port assembly. */


/* Free temporarily assigned user vars. */

  cxOutputDataSet( cxMDWPortIDOut[0], (void *)cxP_Out_Lattice_1 );
  cxOutputDataSet( cxMDWPortIDOut[1], (void *)cxP_Out_Lattice_2 );
  cxOutputDataSet( cxMDWPortIDOut[2], (void *)cxP_Out_Lattice_3 );
  return( cx_err_none );
}
