"""Localizations for MDTools for Python by James Phillips.
RCS: $Id: md_local.py,v 0.6 1996/05/08 20:04:04 jim Exp $
"""
# $Log: md_local.py,v $
# Revision 0.6  1996/05/08 20:04:04  jim
# Fixed NEXTSTEP versions of xyplotfunction and pdbdisplayfunction.
#
# Revision 0.5  1996/05/07 22:22:46  jim
# Started using RCS.
#

import os
import tempfile
import sys

try:
	ostype = os.environ['OSTYPE']
except:
	ostype = '???'

pdbdisplaystdin = None

if ( ostype == 'NeXT' ):
	def xyplotfunction(filename=None):
		if ( filename ):
			os.system('open ' + filename)
		else:
			filename = tempfile.mktemp() + '.dat'
			os.system('( sleep 3; open ' + filename + ' )&')
			return filename
	def pdbdisplayfunction(filename=None):
		if ( filename ):
			os.system('open ' + filename)
		else:
			filename = tempfile.mktemp() + '.pdb'
			os.system('( sleep 3; open ' + filename + ' )&')
			return filename
	def pdbdisplaysend(command):
		print 'Does not apply.'
elif ( ostype == 'IRIX' or ostype == 'HP-UX' ):
	_xyplotfile = '/tmp/md.py.pipe.' + os.environ['USER'] + '.dat'
	try: os.stat(_xyplotfile)
	except: os.system('mknod ' + _xyplotfile + ' p')
	def xyplotfunction(filename=None):
		global _xyplotfile
		if ( filename ):
			os.system('xgraph < ' + filename + ' &')
		else:
			os.system('xgraph < ' + _xyplotfile + ' &')
			return _xyplotfile
	_pdbdisplayfile = '/tmp/md.py.pipe.' + os.environ['USER'] + '.pdb'
	try: os.stat(_pdbdisplayfile)
	except: os.system('mknod ' + _pdbdisplayfile + ' p')
	def pdbdisplayfunction(filename=None):
		global pdbdisplaystdin, _pdbdisplayfile
		if ( not pdbdisplaystdin ):
			pdbdisplaystdin = os.popen('rasmol','w')
		if ( filename ):
			try:
				pdbdisplaystdin.write('zap\nload pdb ' + filename + '\n')
				pdbdisplaystdin.flush()
			except IOError:
				pdbdisplaystdin = os.popen('rasmol','w')
				pdbdisplaystdin.write('zap\nload pdb ' + filename + '\n')
				pdbdisplaystdin.flush()
		else:
			try:
				pdbdisplaystdin.write('zap\nload pdb ' + _pdbdisplayfile + '\n')
				pdbdisplaystdin.flush()
			except IOError:
				pdbdisplaystdin = os.popen('rasmol','w')
				pdbdisplaystdin.write('zap\nload pdb ' + _pdbdisplayfile + '\n')
				pdbdisplaystdin.flush()
			return _pdbdisplayfile
	def pdbdisplaysend(command):
		global pdbdisplaystdin
		if ( not pdbdisplaystdin ):
			pdbdisplaystdin = os.popen('rasmol','w')
		pdbdisplaystdin.write(command + '\n')
		pdbdisplaystdin.flush()
else:
	def xyplotfunction(filename):
		if ( filename ):
			print 'open',filename
		else:
			filename = tempfile.mktemp() + '.dat'
			print 'open',filename
			return filename
	def pdbdisplayfunction(filename):
		if ( filename ):
			print 'open',filename
		else:
			filename = tempfile.mktemp() + '.pdb'
			print 'open',filename
			return filename
	def pdbdisplaysend(command):
		print 'Does not apply.'

if hasattr(sys,'exitfunc'): _oldexitfunc = sys.exitfunc
else: _oldexitfunc = None

def _newexitfunc():
	global _oldexitfunc
	try:
		pdbdisplaystdin.write('exit\n')
		pdbdisplaystdin.flush()
	except:
		pass
	if ( _oldexitfunc ): _oldexitfunc()

sys.exitfunc = _newexitfunc

